/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.Loggers;
import org.jdbcdslog.ProxyUtils;
import org.jdbcdslog.StatementLoggingHandlerTemplate;

public class StatementLoggingHandler
extends StatementLoggingHandlerTemplate {
    protected static final Set<String> EXECUTE_METHODS = new HashSet<String>(Arrays.asList("addBatch", "execute", "executeQuery", "executeUpdate", "executeBatch"));
    protected StringBuilder batchStatements = null;

    public StatementLoggingHandler(Statement statement) {
        super(statement);
    }

    protected boolean needsLogging(Object proxy, Method method, Object[] args) {
        return (Loggers.statementLogger.isInfoEnabled() || Loggers.slowQueryLogger.isInfoEnabled()) && EXECUTE_METHODS.contains(method.getName());
    }

    protected void appendStatement(StringBuilder sb, Object proxy, Method method, Object[] args) {
        LogUtils.appendSql(sb, args == null || args.length == 0 ? null : args[0].toString(), null, null);
    }

    protected void doAddBatch(Object proxy, Method method, Object[] args) {
        if (this.batchStatements == null) {
            this.batchStatements = new StringBuilder();
        }
        this.batchStatements.append("\n");
        this.appendStatement(this.batchStatements, proxy, method, args);
        this.batchStatements.append(';');
    }

    protected void appendBatchStatements(StringBuilder sb) {
        if (this.batchStatements != null) {
            sb.append((CharSequence)this.batchStatements);
            this.batchStatements = null;
        }
    }

    protected Object doAfterInvoke(Object proxy, Method method, Object[] args, Object result) {
        Object r = result;
        if ("unwrap".equals(method.getName())) {
            Class unwrapClass = (Class)args[0];
            if (r == this.target && unwrapClass.isInstance(proxy)) {
                r = proxy;
            } else if (unwrapClass.isInterface() && Statement.class.isAssignableFrom(unwrapClass)) {
                r = ProxyUtils.wrapByStatementProxy(r);
            }
        }
        if (r instanceof ResultSet) {
            r = ProxyUtils.wrapByResultSetProxy((ResultSet)r);
        }
        return r;
    }

    protected void handleException(Throwable t, Object proxy, Method method, Object[] args) throws Throwable {
        LogUtils.handleException(t, Loggers.statementLogger, LogUtils.createLogEntry(method, args == null || args.length == 0 ? null : args[0].toString(), null, null));
    }
}

