/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Map;
import org.jdbcdslog.ConfigurationParameters;
import org.jdbcdslog.LogMetaData;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.Loggers;
import org.jdbcdslog.LoggingHandlerSupport;
import org.jdbcdslog.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetLoggingHandler
extends LoggingHandlerSupport<ResultSet> {
    private int resultCount = 0;
    private long totalFetchTime = 0L;
    private LogMetaData logMetaData = null;

    public ResultSetLoggingHandler(LogMetaData logMetaData, ResultSet target) {
        super(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object r = null;
        long startTimeInNano = System.nanoTime();
        Map<String, String> oldMdc = LogUtils.setMdc(this.logMetaData);
        try {
            try {
                r = method.invoke(this.target, args);
            }
            catch (Throwable e) {
                LogUtils.handleException(e, Loggers.resultSetLogger, LogUtils.createLogEntry(method, null, null, null));
            }
            if ("unwrap".equals(method.getName())) {
                Class unwrapClass = (Class)args[0];
                if (r == this.target && unwrapClass.isInstance(proxy)) {
                    r = proxy;
                } else if (unwrapClass.isInterface() && ResultSet.class.isAssignableFrom(unwrapClass)) {
                    r = ProxyUtils.wrapByResultSetProxy(this.logMetaData, (ResultSet)this.target);
                }
            }
            if (Loggers.resultSetLogger.isInfoEnabled() && method.getName().equals("next")) {
                long elapsedTimeInNano = System.nanoTime() - startTimeInNano;
                this.totalFetchTime += elapsedTimeInNano;
                if (((Boolean)r).booleanValue()) {
                    ++this.resultCount;
                    if (Loggers.resultSetLogger.isDebugEnabled()) {
                        ResultSetMetaData md = ((ResultSet)this.target).getMetaData();
                        StringBuilder sb = new StringBuilder(method.getDeclaringClass().getName()).append(".").append(method.getName()).append(": ");
                        sb.append(" {");
                        for (int i = 1; i <= md.getColumnCount(); ++i) {
                            if (i > 1) {
                                sb.append(", ");
                            }
                            sb.append(ConfigurationParameters.rdbmsSpecifics.formatParameter(((ResultSet)this.target).getObject(i)));
                        }
                        sb.append("} Row Number: ").append(this.resultCount);
                        LogUtils.appendStackTrace(sb);
                        LogUtils.appendElapsedTime(sb, elapsedTimeInNano);
                        Loggers.resultSetLogger.debug(sb.toString());
                    }
                } else {
                    StringBuilder sb = new StringBuilder(method.getDeclaringClass().getName()).append(".").append(method.getName()).append(": ").append(" Total Results: ").append(this.resultCount).append(".  Total Fetch Time: ").append(String.format("%.9f", (double)this.totalFetchTime / 1.0E9)).append(" s.");
                    this.totalFetchTime = 0L;
                    LogUtils.appendStackTrace(sb);
                    LogUtils.appendElapsedTime(sb, elapsedTimeInNano);
                    Loggers.resultSetLogger.info(sb.toString());
                }
            }
        }
        finally {
            LogUtils.resetMdc(oldMdc);
        }
        return r;
    }
}

