/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class SuperSonicBeanDeserializer
extends BeanDeserializer {
    private static final long serialVersionUID = 1L;
    protected final SerializedString[] _orderedPropertyNames;
    protected SettableBeanProperty[] _orderedProperties;

    public SuperSonicBeanDeserializer(BeanDeserializer src, List<SettableBeanProperty> props) {
        super((BeanDeserializerBase)src);
        int len = props.size();
        this._orderedPropertyNames = new SerializedString[len];
        for (int i = 0; i < len; ++i) {
            this._orderedPropertyNames[i] = new SerializedString(props.get(i).getName());
        }
    }

    protected SuperSonicBeanDeserializer(SuperSonicBeanDeserializer src, NameTransformer unwrapper) {
        super((BeanDeserializerBase)src, unwrapper);
        this._orderedProperties = src._orderedProperties;
        this._orderedPropertyNames = src._orderedPropertyNames;
    }

    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
        return new SuperSonicBeanDeserializer(this, unwrapper);
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        int i;
        super.resolve(ctxt);
        if (this._externalTypeIdHandler != null || this._unwrappedPropertyHandler != null) {
            return;
        }
        int len = this._orderedPropertyNames.length;
        ArrayList<SettableBeanProperty> props = new ArrayList<SettableBeanProperty>(len);
        for (i = 0; i < len; ++i) {
            SettableBeanProperty prop = this._beanProperties.find(this._orderedPropertyNames[i].toString());
            if (prop == null) continue;
            props.add(prop);
        }
        if (i == 0) {
            throw new IllegalStateException("Afterburner internal error: BeanDeserializer for " + this._beanType + " has no properties that match expected ordering (should have " + len + ") -- can not create optimized deserializer");
        }
        this._orderedProperties = props.toArray(new SettableBeanProperty[props.size()]);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object id;
        if (!this._vanillaProcessing || this._objectIdReader != null) {
            return super.deserialize(p, ctxt);
        }
        if (!p.isExpectedStartObjectToken()) {
            return this._deserializeOther(p, ctxt, p.getCurrentToken());
        }
        if (this._nonStandardCreation) {
            p.nextToken();
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p, ctxt);
            }
            Object bean = this.deserializeFromObjectUsingNonDefault(p, ctxt);
            if (this._injectables != null) {
                this.injectValues(ctxt, bean);
            }
            return bean;
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean);
        if (p.canReadObjectId() && (id = p.getObjectId()) != null) {
            this._handleTypedObjectId(p, ctxt, bean, id);
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        int len = this._orderedProperties.length;
        for (int i = 0; i < len; ++i) {
            SettableBeanProperty prop = this._orderedProperties[i];
            if (!p.nextFieldName((SerializableString)this._orderedPropertyNames[i])) {
                if (p.getCurrentToken() == JsonToken.END_OBJECT) {
                    return bean;
                }
                return super.deserialize(p, ctxt, bean);
            }
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean);
                continue;
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
        }
        if (p.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(p, ctxt, bean);
        }
        return bean;
    }

    public final Object deserialize(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        p.setCurrentValue(bean);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(p, ctxt, bean);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(p, ctxt, bean);
        }
        SettableBeanProperty prop = this._orderedProperties[0];
        if (p.isExpectedStartObjectToken() ? !p.nextFieldName((SerializableString)this._orderedPropertyNames[0]) : !p.hasToken(JsonToken.FIELD_NAME) || !prop.getName().equals(p.getCurrentName())) {
            return super.deserialize(p, ctxt, bean);
        }
        p.nextToken();
        try {
            prop.deserializeAndSet(p, ctxt, bean);
        }
        catch (Exception e) {
            this.wrapAndThrow(e, bean, prop.getName(), ctxt);
        }
        int len = this._orderedProperties.length;
        for (int i = 1; i < len; ++i) {
            if (!p.nextFieldName((SerializableString)this._orderedPropertyNames[i])) {
                if (p.hasToken(JsonToken.END_OBJECT)) {
                    return bean;
                }
                return super.deserialize(p, ctxt, bean);
            }
            prop = this._orderedProperties[i];
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean);
                continue;
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
        }
        if (p.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(p, ctxt, bean);
        }
        return bean;
    }

    public final Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object id;
        if (this._objectIdReader != null && this._objectIdReader.maySerializeAsObject() && p.hasTokenId(5) && this._objectIdReader.isValidReferencePropertyName(p.getCurrentName(), p)) {
            return this.deserializeFromObjectId(p, ctxt);
        }
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p, ctxt);
            }
            Object bean = this.deserializeFromObjectUsingNonDefault(p, ctxt);
            if (this._injectables != null) {
                this.injectValues(ctxt, bean);
            }
            return bean;
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean);
        if (p.canReadObjectId() && (id = p.getObjectId()) != null) {
            this._handleTypedObjectId(p, ctxt, bean, id);
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        SettableBeanProperty prop = this._orderedProperties[0];
        if (p.isExpectedStartObjectToken() ? !p.nextFieldName((SerializableString)this._orderedPropertyNames[0]) : !p.hasToken(JsonToken.FIELD_NAME) || !prop.getName().equals(p.getCurrentName())) {
            return super.deserialize(p, ctxt, bean);
        }
        p.nextToken();
        try {
            prop.deserializeAndSet(p, ctxt, bean);
        }
        catch (Exception e) {
            this.wrapAndThrow(e, bean, prop.getName(), ctxt);
        }
        int len = this._orderedProperties.length;
        for (int i = 1; i < len; ++i) {
            prop = this._orderedProperties[i];
            if (!p.nextFieldName((SerializableString)this._orderedPropertyNames[i])) {
                if (p.hasToken(JsonToken.END_OBJECT)) {
                    return bean;
                }
                return super.deserialize(p, ctxt, bean);
            }
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean);
                continue;
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
        }
        if (p.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(p, ctxt, bean);
        }
        return bean;
    }
}

