/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.skife.jdbi.v2.Cleanables;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.tweak.BaseStatementCustomizer;
import org.skife.jdbi.v2.tweak.StatementCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseStatement {
    private final List<Cleanables.Cleanable> cleanables = new ArrayList<Cleanables.Cleanable>();
    private final Collection<StatementCustomizer> customizers = new ArrayList<StatementCustomizer>();
    private final ConcreteStatementContext context;
    private final Foreman foreman;

    protected BaseStatement(ConcreteStatementContext context, Foreman foreman) {
        this.context = context;
        this.foreman = foreman.createChild();
        this.addCustomizer(new StatementCleaningCustomizer());
    }

    protected final Foreman getForeman() {
        return this.foreman;
    }

    protected final ConcreteStatementContext getConcreteContext() {
        return this.context;
    }

    public final StatementContext getContext() {
        return this.context;
    }

    protected void addCustomizers(Collection<StatementCustomizer> customizers) {
        this.customizers.addAll(customizers);
    }

    protected void addCustomizer(StatementCustomizer customizer) {
        this.customizers.add(customizer);
    }

    protected Collection<StatementCustomizer> getStatementCustomizers() {
        return this.customizers;
    }

    protected final void beforeExecution(PreparedStatement stmt) {
        for (StatementCustomizer customizer : this.customizers) {
            try {
                customizer.beforeExecution(stmt, this.context);
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Exception thrown in statement customization", e, this.context);
            }
        }
    }

    protected final void afterExecution(PreparedStatement stmt) {
        for (StatementCustomizer customizer : this.customizers) {
            try {
                customizer.afterExecution(stmt, this.context);
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Exception thrown in statement customization", e, this.context);
            }
        }
    }

    protected final void cleanup() {
        for (StatementCustomizer customizer : this.customizers) {
            try {
                customizer.cleanup(this.context);
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Could not clean up", e, this.context);
            }
        }
    }

    protected void addCleanable(Cleanables.Cleanable cleanable) {
        this.cleanables.add(cleanable);
    }

    class StatementCleaningCustomizer
    extends BaseStatementCustomizer {
        StatementCleaningCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void cleanup(StatementContext ctx) throws SQLException {
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            try {
                Collections.reverse(BaseStatement.this.cleanables);
                for (Cleanables.Cleanable cleanable : BaseStatement.this.cleanables) {
                    try {
                        cleanable.cleanup();
                    }
                    catch (SQLException sqlException) {
                        exceptions.add(sqlException);
                    }
                }
                BaseStatement.this.cleanables.clear();
            }
            finally {
                if (exceptions.size() > 1) {
                    for (int i = 0; i < exceptions.size() - 1; ++i) {
                        ((SQLException)exceptions.get(i)).setNextException((SQLException)exceptions.get(i + 1));
                    }
                }
                if (exceptions.size() > 0) {
                    throw (SQLException)exceptions.get(0);
                }
            }
        }
    }
}

