/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionState;
import org.skife.jdbi.v2.tweak.StatementBuilder;

class Cleanables {
    Cleanables() {
    }

    static Cleanable forResultSet(final ResultSet rs) {
        return new Cleanable(){

            public void cleanup() throws SQLException {
                if (rs != null) {
                    rs.close();
                }
            }
        };
    }

    static Cleanable forStatement(final Statement stmt) {
        return new Cleanable(){

            public void cleanup() throws SQLException {
                if (stmt != null) {
                    stmt.close();
                }
            }
        };
    }

    static Cleanable forHandle(final Handle handle, final TransactionState state) {
        return new Cleanable(){

            public void cleanup() throws SQLException {
                if (handle != null) {
                    if (handle.isInTransaction()) {
                        if (state == TransactionState.COMMIT) {
                            handle.commit();
                        } else {
                            handle.rollback();
                        }
                    }
                    handle.close();
                }
            }
        };
    }

    static class StatementBuilderCleanable
    implements Cleanable {
        private final StatementBuilder statementBuilder;
        private final Connection conn;
        private final String sql;
        private final Statement stmt;

        StatementBuilderCleanable(StatementBuilder statementBuilder, Connection conn, String sql, Statement stmt) {
            this.statementBuilder = statementBuilder;
            this.conn = conn;
            this.sql = sql;
            this.stmt = stmt;
        }

        public void cleanup() throws SQLException {
            if (this.statementBuilder != null) {
                this.statementBuilder.close(this.conn, this.sql, this.stmt);
            }
        }
    }

    static interface Cleanable {
        public void cleanup() throws SQLException;
    }
}

