/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.Map;
import java.util.regex.Pattern;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.tweak.StatementLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Script {
    private static final Pattern WHITESPACE_ONLY = Pattern.compile("^\\s*$");
    private Handle handle;
    private final StatementLocator locator;
    private final String name;
    private final Map<String, Object> globalStatementAttributes;

    Script(Handle h, StatementLocator locator, String name, Map<String, Object> globalStatementAttributes) {
        this.handle = h;
        this.locator = locator;
        this.name = name;
        this.globalStatementAttributes = globalStatementAttributes;
    }

    public int[] execute() {
        String script;
        ConcreteStatementContext ctx = new ConcreteStatementContext(this.globalStatementAttributes);
        try {
            script = this.locator.locate(this.name, ctx);
        }
        catch (Exception e) {
            throw new UnableToExecuteStatementException(String.format("Error while loading script [%s]", this.name), e, ctx);
        }
        String[] statements = script.replaceAll("\n", " ").replaceAll("\r", "").split(";");
        Batch b = this.handle.createBatch();
        for (String s : statements) {
            if (WHITESPACE_ONLY.matcher(s).matches()) continue;
            b.add(s);
        }
        return b.execute();
    }
}

