/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.Binder;
import org.skife.jdbi.v2.sqlobject.BinderFactory;

class BindBeanFactory
implements BinderFactory {
    BindBeanFactory() {
    }

    public Binder build(Annotation annotation) {
        return new Binder<BindBean, Object>(){

            @Override
            public void bind(SQLStatement q, BindBean bind, Object arg) {
                String prefix = "___jdbi_bare___".equals(bind.value()) ? "" : bind.value() + ".";
                try {
                    PropertyDescriptor[] props;
                    BeanInfo infos = Introspector.getBeanInfo(arg.getClass());
                    for (PropertyDescriptor prop : props = infos.getPropertyDescriptors()) {
                        q.bind(prefix + prop.getName(), prop.getReadMethod().invoke(arg, new Object[0]));
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("unable to bind bean properties", e);
                }
            }
        };
    }
}

