/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.Iterator;
import java.util.List;
import org.skife.jdbi.com.fasterxml.classmate.ResolvedType;
import org.skife.jdbi.com.fasterxml.classmate.members.ResolvedMethod;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultBearing;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.sqlobject.customizers.SingleValueResult;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ResultReturnThing {
    ResultReturnThing() {
    }

    public Object map(ResolvedMethod method, Query q, HandleDing h) {
        if (method.getRawMember().isAnnotationPresent(Mapper.class)) {
            ResultSetMapper<?> mapper;
            try {
                mapper = method.getRawMember().getAnnotation(Mapper.class).value().newInstance();
            }
            catch (Exception e) {
                throw new UnableToCreateStatementException("unable to access mapper", e);
            }
            return this.result(q.map(mapper), h);
        }
        return this.result(q.mapTo(this.mapTo(method)), h);
    }

    static ResultReturnThing forType(ResolvedMethod method) {
        ResolvedType return_type = method.getReturnType();
        if (return_type.isInstanceOf(ResultBearing.class)) {
            return new ResultBearingResultReturnThing(method);
        }
        if (return_type.isInstanceOf(Iterable.class)) {
            return new IterableReturningThing(method);
        }
        if (return_type.isInstanceOf(Iterator.class)) {
            return new IteratorResultReturnThing(method);
        }
        return new SingleValueResultReturnThing(method);
    }

    protected abstract Object result(ResultBearing var1, HandleDing var2);

    protected abstract Class<?> mapTo(ResolvedMethod var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IterableReturningThing
    extends ResultReturnThing {
        private final ResolvedType resolvedType;
        private final Class<?> erased_type;

        public IterableReturningThing(ResolvedMethod method) {
            ResolvedType query_type = method.getReturnType();
            List<ResolvedType> query_return_types = query_type.typeParametersFor(Iterable.class);
            this.resolvedType = query_return_types.get(0);
            this.erased_type = method.getReturnType().getErasedType();
        }

        @Override
        protected Object result(ResultBearing q, HandleDing baton) {
            return q.list(this.erased_type);
        }

        @Override
        protected Class<?> mapTo(ResolvedMethod method) {
            return this.resolvedType.getErasedType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IteratorResultReturnThing
    extends ResultReturnThing {
        private final ResolvedType resolvedType;

        public IteratorResultReturnThing(ResolvedMethod method) {
            ResolvedType query_type = method.getReturnType();
            List<ResolvedType> query_return_types = query_type.typeParametersFor(Iterator.class);
            this.resolvedType = query_return_types.get(0);
        }

        @Override
        protected Object result(ResultBearing q, final HandleDing baton) {
            baton.retain("iterator");
            final ResultIterator itty = q.iterator();
            return new ResultIterator(){

                public void close() {
                    itty.close();
                }

                public boolean hasNext() {
                    boolean has_next = itty.hasNext();
                    if (!has_next) {
                        baton.release("iterator");
                    }
                    return itty.hasNext();
                }

                public Object next() {
                    Object rs = itty.next();
                    boolean has_next = itty.hasNext();
                    if (!has_next) {
                        baton.release("iterator");
                    }
                    return rs;
                }

                public void remove() {
                    itty.remove();
                }
            };
        }

        @Override
        protected Class<?> mapTo(ResolvedMethod method) {
            return this.resolvedType.getErasedType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResultBearingResultReturnThing
    extends ResultReturnThing {
        private final ResolvedType resolvedType;

        public ResultBearingResultReturnThing(ResolvedMethod method) {
            ResolvedType query_type = method.getReturnType();
            List<ResolvedType> query_return_types = query_type.typeParametersFor(Query.class);
            this.resolvedType = query_return_types.get(0);
        }

        @Override
        protected Object result(ResultBearing q, HandleDing baton) {
            return q;
        }

        @Override
        protected Class<?> mapTo(ResolvedMethod method) {
            return this.resolvedType.getErasedType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SingleValueResultReturnThing
    extends ResultReturnThing {
        private final Class<?> returnType;
        private final Class<?> containerType;

        public SingleValueResultReturnThing(ResolvedMethod method) {
            if (method.getRawMember().isAnnotationPresent(SingleValueResult.class)) {
                SingleValueResult svr = method.getRawMember().getAnnotation(SingleValueResult.class);
                this.returnType = svr.value();
                this.containerType = method.getReturnType().getErasedType();
            } else {
                this.returnType = method.getReturnType().getErasedType();
                this.containerType = null;
            }
        }

        @Override
        protected Object result(ResultBearing q, HandleDing baton) {
            return null == this.containerType ? q.first() : q.first(this.containerType);
        }

        @Override
        protected Class<?> mapTo(ResolvedMethod method) {
            return this.returnType;
        }
    }
}

