/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.tweak.StatementRewriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Retention(value=RetentionPolicy.RUNTIME)
@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface OverrideStatementRewriterWith {
    public Class<? extends StatementRewriter> value();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            OverrideStatementRewriterWith anno = (OverrideStatementRewriterWith)annotation;
            try {
                final StatementRewriter rw = this.instantiate(anno.value(), sqlObjectType, method);
                return new SqlStatementCustomizer(){

                    public void apply(SQLStatement q) {
                        q.setStatementRewriter(rw);
                    }
                };
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            OverrideStatementRewriterWith anno = (OverrideStatementRewriterWith)annotation;
            try {
                final StatementRewriter rw = this.instantiate(anno.value(), sqlObjectType, null);
                return new SqlStatementCustomizer(){

                    public void apply(SQLStatement q) {
                        q.setStatementRewriter(rw);
                    }
                };
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            throw new IllegalStateException("Not defined on parameters!");
        }

        private StatementRewriter instantiate(Class<? extends StatementRewriter> value, Class sqlObjectType, Method m) throws Exception {
            try {
                Constructor<? extends StatementRewriter> no_arg = value.getConstructor(new Class[0]);
                return no_arg.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<? extends StatementRewriter> class_arg = value.getConstructor(Class.class);
                    return class_arg.newInstance(sqlObjectType);
                }
                catch (NoSuchMethodException e1) {
                    if (m != null) {
                        Constructor<? extends StatementRewriter> c_m_arg = value.getConstructor(Class.class, Method.class);
                        return c_m_arg.newInstance(sqlObjectType, m);
                    }
                    throw new IllegalStateException("Unable to instantiate, no viable constructor " + value.getName());
                }
            }
        }
    }
}

