/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SqlStatementCustomizingAnnotation(value=Factory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterMapper {
    public Class<? extends ResultSetMapper<?>>[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            RegisterMapper ma = (RegisterMapper)annotation;
            final ResultSetMapper[] m = new ResultSetMapper[ma.value().length];
            try {
                Class<? extends ResultSetMapper<?>>[] mcs = ma.value();
                for (int i = 0; i < mcs.length; ++i) {
                    m[i] = mcs[i].newInstance();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create a specified result set mapper", e);
            }
            return new SqlStatementCustomizer(){

                public void apply(SQLStatement statement) {
                    if (statement instanceof Query) {
                        Query q = (Query)statement;
                        for (ResultSetMapper mapper : m) {
                            q.registerMapper(mapper);
                        }
                    }
                }
            };
        }

        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            RegisterMapper ma = (RegisterMapper)annotation;
            final ResultSetMapper[] m = new ResultSetMapper[ma.value().length];
            try {
                Class<? extends ResultSetMapper<?>>[] mcs = ma.value();
                for (int i = 0; i < mcs.length; ++i) {
                    m[i] = mcs[i].newInstance();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create a specified result set mapper", e);
            }
            return new SqlStatementCustomizer(){

                public void apply(SQLStatement statement) {
                    if (statement instanceof Query) {
                        Query q = (Query)statement;
                        for (ResultSetMapper mapper : m) {
                            q.registerMapper(mapper);
                        }
                    }
                }
            };
        }

        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            throw new UnsupportedOperationException("Not defined for parameter");
        }
    }
}

