// $ANTLR 3.4 org/skife/jdbi/rewriter/colon/ColonStatementLexer.g 2016-04-14 15:48:42

    package org.skife.jdbi.rewriter.colon;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked"})
public class ColonStatementLexer extends Lexer {
    public static final int EOF=-1;
    public static final int COLON=4;
    public static final int DOUBLE_COLON=5;
    public static final int DOUBLE_QUOTED_TEXT=6;
    public static final int ESCAPED_TEXT=7;
    public static final int ESCAPE_SEQUENCE=8;
    public static final int LITERAL=9;
    public static final int NAMED_PARAM=10;
    public static final int POSITIONAL_PARAM=11;
    public static final int QUOTED_TEXT=12;

      @Override
      public void reportError(RecognitionException e) {
        throw new IllegalArgumentException(e);
      }


    // delegates
    // delegators
    public Lexer[] getDelegates() {
        return new Lexer[] {};
    }

    public ColonStatementLexer() {} 
    public ColonStatementLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public ColonStatementLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);
    }
    public String getGrammarFileName() { return "org/skife/jdbi/rewriter/colon/ColonStatementLexer.g"; }

    // $ANTLR start "DOUBLE_COLON"
    public final void mDOUBLE_COLON() throws RecognitionException {
        try {
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:14:22: ({...}? => '::' )
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:14:24: {...}? => '::'
            {
            if ( !((input.LA(2) == ':')) ) {
                throw new FailedPredicateException(input, "DOUBLE_COLON", "input.LA(2) == ':'");
            }

            match("::"); 



            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DOUBLE_COLON"

    // $ANTLR start "COLON"
    public final void mCOLON() throws RecognitionException {
        try {
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:15:15: ({...}? => ':' )
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:15:17: {...}? => ':'
            {
            if ( !((input.LA(2) != ':')) ) {
                throw new FailedPredicateException(input, "COLON", "input.LA(2) != ':'");
            }

            match(':'); 

            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "COLON"

    // $ANTLR start "LITERAL"
    public final void mLITERAL() throws RecognitionException {
        try {
            int _type = LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:8: ( ( 'a' .. 'z' | 'A' .. 'Z' | ' ' | '\\t' | '\\n' | '\\r' | '0' .. '9' | ',' | '*' | '#' | '.' | '@' | '_' | '!' | '=' | ';' | '(' | ')' | '[' | ']' | '+' | '-' | '/' | '>' | '<' | '%' | '&' | '^' | '|' | '$' | '~' | '{' | '}' | '`' | DOUBLE_COLON )+ )
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:10: ( 'a' .. 'z' | 'A' .. 'Z' | ' ' | '\\t' | '\\n' | '\\r' | '0' .. '9' | ',' | '*' | '#' | '.' | '@' | '_' | '!' | '=' | ';' | '(' | ')' | '[' | ']' | '+' | '-' | '/' | '>' | '<' | '%' | '&' | '^' | '|' | '$' | '~' | '{' | '}' | '`' | DOUBLE_COLON )+
            {
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:10: ( 'a' .. 'z' | 'A' .. 'Z' | ' ' | '\\t' | '\\n' | '\\r' | '0' .. '9' | ',' | '*' | '#' | '.' | '@' | '_' | '!' | '=' | ';' | '(' | ')' | '[' | ']' | '+' | '-' | '/' | '>' | '<' | '%' | '&' | '^' | '|' | '$' | '~' | '{' | '}' | '`' | DOUBLE_COLON )+
            int cnt1=0;
            loop1:
            do {
                int alt1=36;
                int LA1_0 = input.LA(1);

                if ( ((LA1_0 >= 'a' && LA1_0 <= 'z')) ) {
                    alt1=1;
                }
                else if ( ((LA1_0 >= 'A' && LA1_0 <= 'Z')) ) {
                    alt1=2;
                }
                else if ( (LA1_0==' ') ) {
                    alt1=3;
                }
                else if ( (LA1_0=='\t') ) {
                    alt1=4;
                }
                else if ( (LA1_0=='\n') ) {
                    alt1=5;
                }
                else if ( (LA1_0=='\r') ) {
                    alt1=6;
                }
                else if ( ((LA1_0 >= '0' && LA1_0 <= '9')) ) {
                    alt1=7;
                }
                else if ( (LA1_0==',') ) {
                    alt1=8;
                }
                else if ( (LA1_0=='*') ) {
                    alt1=9;
                }
                else if ( (LA1_0=='#') ) {
                    alt1=10;
                }
                else if ( (LA1_0=='.') ) {
                    alt1=11;
                }
                else if ( (LA1_0=='@') ) {
                    alt1=12;
                }
                else if ( (LA1_0=='_') ) {
                    alt1=13;
                }
                else if ( (LA1_0=='!') ) {
                    alt1=14;
                }
                else if ( (LA1_0=='=') ) {
                    alt1=15;
                }
                else if ( (LA1_0==';') ) {
                    alt1=16;
                }
                else if ( (LA1_0=='(') ) {
                    alt1=17;
                }
                else if ( (LA1_0==')') ) {
                    alt1=18;
                }
                else if ( (LA1_0=='[') ) {
                    alt1=19;
                }
                else if ( (LA1_0==']') ) {
                    alt1=20;
                }
                else if ( (LA1_0=='+') ) {
                    alt1=21;
                }
                else if ( (LA1_0=='-') ) {
                    alt1=22;
                }
                else if ( (LA1_0=='/') ) {
                    alt1=23;
                }
                else if ( (LA1_0=='>') ) {
                    alt1=24;
                }
                else if ( (LA1_0=='<') ) {
                    alt1=25;
                }
                else if ( (LA1_0=='%') ) {
                    alt1=26;
                }
                else if ( (LA1_0=='&') ) {
                    alt1=27;
                }
                else if ( (LA1_0=='^') ) {
                    alt1=28;
                }
                else if ( (LA1_0=='|') ) {
                    alt1=29;
                }
                else if ( (LA1_0=='$') ) {
                    alt1=30;
                }
                else if ( (LA1_0=='~') ) {
                    alt1=31;
                }
                else if ( (LA1_0=='{') ) {
                    alt1=32;
                }
                else if ( (LA1_0=='}') ) {
                    alt1=33;
                }
                else if ( (LA1_0=='`') ) {
                    alt1=34;
                }
                else if ( (LA1_0==':') && ((input.LA(2) == ':'))) {
                    alt1=35;
                }


                switch (alt1) {
            	case 1 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:11: 'a' .. 'z'
            	    {
            	    matchRange('a','z'); 

            	    }
            	    break;
            	case 2 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:22: 'A' .. 'Z'
            	    {
            	    matchRange('A','Z'); 

            	    }
            	    break;
            	case 3 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:33: ' '
            	    {
            	    match(' '); 

            	    }
            	    break;
            	case 4 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:39: '\\t'
            	    {
            	    match('\t'); 

            	    }
            	    break;
            	case 5 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:46: '\\n'
            	    {
            	    match('\n'); 

            	    }
            	    break;
            	case 6 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:53: '\\r'
            	    {
            	    match('\r'); 

            	    }
            	    break;
            	case 7 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:60: '0' .. '9'
            	    {
            	    matchRange('0','9'); 

            	    }
            	    break;
            	case 8 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:71: ','
            	    {
            	    match(','); 

            	    }
            	    break;
            	case 9 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:77: '*'
            	    {
            	    match('*'); 

            	    }
            	    break;
            	case 10 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:83: '#'
            	    {
            	    match('#'); 

            	    }
            	    break;
            	case 11 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:89: '.'
            	    {
            	    match('.'); 

            	    }
            	    break;
            	case 12 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:95: '@'
            	    {
            	    match('@'); 

            	    }
            	    break;
            	case 13 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:101: '_'
            	    {
            	    match('_'); 

            	    }
            	    break;
            	case 14 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:17:107: '!'
            	    {
            	    match('!'); 

            	    }
            	    break;
            	case 15 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:13: '='
            	    {
            	    match('='); 

            	    }
            	    break;
            	case 16 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:19: ';'
            	    {
            	    match(';'); 

            	    }
            	    break;
            	case 17 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:25: '('
            	    {
            	    match('('); 

            	    }
            	    break;
            	case 18 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:31: ')'
            	    {
            	    match(')'); 

            	    }
            	    break;
            	case 19 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:37: '['
            	    {
            	    match('['); 

            	    }
            	    break;
            	case 20 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:43: ']'
            	    {
            	    match(']'); 

            	    }
            	    break;
            	case 21 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:49: '+'
            	    {
            	    match('+'); 

            	    }
            	    break;
            	case 22 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:55: '-'
            	    {
            	    match('-'); 

            	    }
            	    break;
            	case 23 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:61: '/'
            	    {
            	    match('/'); 

            	    }
            	    break;
            	case 24 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:67: '>'
            	    {
            	    match('>'); 

            	    }
            	    break;
            	case 25 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:73: '<'
            	    {
            	    match('<'); 

            	    }
            	    break;
            	case 26 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:79: '%'
            	    {
            	    match('%'); 

            	    }
            	    break;
            	case 27 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:85: '&'
            	    {
            	    match('&'); 

            	    }
            	    break;
            	case 28 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:91: '^'
            	    {
            	    match('^'); 

            	    }
            	    break;
            	case 29 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:18:97: '|'
            	    {
            	    match('|'); 

            	    }
            	    break;
            	case 30 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:19:13: '$'
            	    {
            	    match('$'); 

            	    }
            	    break;
            	case 31 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:19:19: '~'
            	    {
            	    match('~'); 

            	    }
            	    break;
            	case 32 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:19:25: '{'
            	    {
            	    match('{'); 

            	    }
            	    break;
            	case 33 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:19:31: '}'
            	    {
            	    match('}'); 

            	    }
            	    break;
            	case 34 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:19:37: '`'
            	    {
            	    match('`'); 

            	    }
            	    break;
            	case 35 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:19:43: DOUBLE_COLON
            	    {
            	    mDOUBLE_COLON(); 


            	    }
            	    break;

            	default :
            	    if ( cnt1 >= 1 ) break loop1;
                        EarlyExitException eee =
                            new EarlyExitException(1, input);
                        throw eee;
                }
                cnt1++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LITERAL"

    // $ANTLR start "NAMED_PARAM"
    public final void mNAMED_PARAM() throws RecognitionException {
        try {
            int _type = NAMED_PARAM;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:20:12: ( COLON ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '_' | '.' | '#' )+ )
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:20:14: COLON ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '_' | '.' | '#' )+
            {
            mCOLON(); 


            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:20:20: ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '_' | '.' | '#' )+
            int cnt2=0;
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case '#':
                case '.':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '_':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:
            	    {
            	    if ( input.LA(1)=='#'||input.LA(1)=='.'||(input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt2 >= 1 ) break loop2;
                        EarlyExitException eee =
                            new EarlyExitException(2, input);
                        throw eee;
                }
                cnt2++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NAMED_PARAM"

    // $ANTLR start "POSITIONAL_PARAM"
    public final void mPOSITIONAL_PARAM() throws RecognitionException {
        try {
            int _type = POSITIONAL_PARAM;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:21:17: ( '?' )
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:21:19: '?'
            {
            match('?'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "POSITIONAL_PARAM"

    // $ANTLR start "QUOTED_TEXT"
    public final void mQUOTED_TEXT() throws RecognitionException {
        try {
            int _type = QUOTED_TEXT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:22:12: ( ( '\\'' ( ESCAPE_SEQUENCE |~ '\\'' )* '\\'' ) )
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:22:14: ( '\\'' ( ESCAPE_SEQUENCE |~ '\\'' )* '\\'' )
            {
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:22:14: ( '\\'' ( ESCAPE_SEQUENCE |~ '\\'' )* '\\'' )
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:22:15: '\\'' ( ESCAPE_SEQUENCE |~ '\\'' )* '\\''
            {
            match('\''); 

            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:22:20: ( ESCAPE_SEQUENCE |~ '\\'' )*
            loop3:
            do {
                int alt3=3;
                int LA3_0 = input.LA(1);

                if ( (LA3_0=='\\') ) {
                    int LA3_2 = input.LA(2);

                    if ( (LA3_2=='\'') ) {
                        int LA3_4 = input.LA(3);

                        if ( ((LA3_4 >= '\u0000' && LA3_4 <= '\uFFFF')) ) {
                            alt3=1;
                        }

                        else {
                            alt3=2;
                        }


                    }
                    else if ( ((LA3_2 >= '\u0000' && LA3_2 <= '&')||(LA3_2 >= '(' && LA3_2 <= '\uFFFF')) ) {
                        alt3=2;
                    }


                }
                else if ( ((LA3_0 >= '\u0000' && LA3_0 <= '&')||(LA3_0 >= '(' && LA3_0 <= '[')||(LA3_0 >= ']' && LA3_0 <= '\uFFFF')) ) {
                    alt3=2;
                }


                switch (alt3) {
            	case 1 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:22:22: ESCAPE_SEQUENCE
            	    {
            	    mESCAPE_SEQUENCE(); 


            	    }
            	    break;
            	case 2 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:22:40: ~ '\\''
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop3;
                }
            } while (true);


            match('\''); 

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUOTED_TEXT"

    // $ANTLR start "DOUBLE_QUOTED_TEXT"
    public final void mDOUBLE_QUOTED_TEXT() throws RecognitionException {
        try {
            int _type = DOUBLE_QUOTED_TEXT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:23:19: ( ( '\"' (~ '\"' )+ '\"' ) )
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:23:21: ( '\"' (~ '\"' )+ '\"' )
            {
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:23:21: ( '\"' (~ '\"' )+ '\"' )
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:23:22: '\"' (~ '\"' )+ '\"'
            {
            match('\"'); 

            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:23:26: (~ '\"' )+
            int cnt4=0;
            loop4:
            do {
                int alt4=2;
                int LA4_0 = input.LA(1);

                if ( ((LA4_0 >= '\u0000' && LA4_0 <= '!')||(LA4_0 >= '#' && LA4_0 <= '\uFFFF')) ) {
                    alt4=1;
                }


                switch (alt4) {
            	case 1 :
            	    // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '!')||(input.LA(1) >= '#' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt4 >= 1 ) break loop4;
                        EarlyExitException eee =
                            new EarlyExitException(4, input);
                        throw eee;
                }
                cnt4++;
            } while (true);


            match('\"'); 

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DOUBLE_QUOTED_TEXT"

    // $ANTLR start "ESCAPED_TEXT"
    public final void mESCAPED_TEXT() throws RecognitionException {
        try {
            int _type = ESCAPED_TEXT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:24:14: ( '\\\\' . )
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:24:16: '\\\\' .
            {
            match('\\'); 

            matchAny(); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ESCAPED_TEXT"

    // $ANTLR start "ESCAPE_SEQUENCE"
    public final void mESCAPE_SEQUENCE() throws RecognitionException {
        try {
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:26:25: ( '\\\\' '\\'' )
            // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:26:29: '\\\\' '\\''
            {
            match('\\'); 

            match('\''); 

            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ESCAPE_SEQUENCE"

    public void mTokens() throws RecognitionException {
        // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:1:8: ( LITERAL | NAMED_PARAM | POSITIONAL_PARAM | QUOTED_TEXT | DOUBLE_QUOTED_TEXT | ESCAPED_TEXT )
        int alt5=6;
        int LA5_0 = input.LA(1);

        if ( ((LA5_0 >= '\t' && LA5_0 <= '\n')||LA5_0=='\r'||(LA5_0 >= ' ' && LA5_0 <= '!')||(LA5_0 >= '#' && LA5_0 <= '&')||(LA5_0 >= '(' && LA5_0 <= '9')||(LA5_0 >= ';' && LA5_0 <= '>')||(LA5_0 >= '@' && LA5_0 <= '[')||(LA5_0 >= ']' && LA5_0 <= '~')) ) {
            alt5=1;
        }
        else if ( (LA5_0==':') && (((input.LA(2) != ':')||(input.LA(2) == ':')))) {
            int LA5_2 = input.LA(2);

            if ( (LA5_2==':') && ((input.LA(2) == ':'))) {
                alt5=1;
            }
            else if ( (LA5_2=='#'||LA5_2=='.'||(LA5_2 >= '0' && LA5_2 <= '9')||(LA5_2 >= 'A' && LA5_2 <= 'Z')||LA5_2=='_'||(LA5_2 >= 'a' && LA5_2 <= 'z')) && ((input.LA(2) != ':'))) {
                alt5=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 2, input);

                throw nvae;

            }
        }
        else if ( (LA5_0=='?') ) {
            alt5=3;
        }
        else if ( (LA5_0=='\'') ) {
            alt5=4;
        }
        else if ( (LA5_0=='\"') ) {
            alt5=5;
        }
        else if ( (LA5_0=='\\') ) {
            alt5=6;
        }
        else {
            NoViableAltException nvae =
                new NoViableAltException("", 5, 0, input);

            throw nvae;

        }
        switch (alt5) {
            case 1 :
                // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:1:10: LITERAL
                {
                mLITERAL(); 


                }
                break;
            case 2 :
                // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:1:18: NAMED_PARAM
                {
                mNAMED_PARAM(); 


                }
                break;
            case 3 :
                // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:1:30: POSITIONAL_PARAM
                {
                mPOSITIONAL_PARAM(); 


                }
                break;
            case 4 :
                // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:1:47: QUOTED_TEXT
                {
                mQUOTED_TEXT(); 


                }
                break;
            case 5 :
                // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:1:59: DOUBLE_QUOTED_TEXT
                {
                mDOUBLE_QUOTED_TEXT(); 


                }
                break;
            case 6 :
                // org/skife/jdbi/rewriter/colon/ColonStatementLexer.g:1:78: ESCAPED_TEXT
                {
                mESCAPED_TEXT(); 


                }
                break;

        }

    }


 

}