/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.freemarker.internal;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.SimpleExtensionConfigurer;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.freemarker.FreemarkerConfig;
import org.jdbi.v3.freemarker.FreemarkerSqlLocator;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.internal.SqlAnnotations;
import org.jdbi.v3.sqlobject.locator.SqlLocator;

public class UseFreemarkerSqlLocatorImpl
extends SimpleExtensionConfigurer {
    private final SqlLocator locator = (type, method, config) -> SqlAnnotations.getAnnotationValue((Method)method).orElseGet(method::getName);
    private final TemplateEngine templateEngine = (templateName, ctx) -> {
        String string;
        Template template = FreemarkerSqlLocator.findTemplate(((FreemarkerConfig)ctx.getConfig(FreemarkerConfig.class)).getFreemarkerConfiguration(), sqlObjectType, templateName);
        StringWriter writer = new StringWriter();
        try {
            template.process((Object)ctx.getAttributes(), (Writer)writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TemplateException | IOException e) {
                throw new IllegalStateException("Failed to render template " + templateName, e);
            }
        }
        writer.close();
        return string;
    };

    public UseFreemarkerSqlLocatorImpl(Annotation annotation, Class<?> sqlObjectType) {
    }

    public void configure(ConfigRegistry config, Annotation annotation, Class<?> sqlObjectType) {
        ((SqlObjects)config.get(SqlObjects.class)).setSqlLocator(this.locator);
        ((SqlStatements)config.get(SqlStatements.class)).setTemplateEngine(this.templateEngine);
    }
}

