/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.jackson2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.jackson2.Jackson2Config;
import org.jdbi.v3.json.JsonMapper;

class JacksonJsonMapper
implements JsonMapper {
    JacksonJsonMapper() {
    }

    public String toJson(Type type, Object value, ConfigRegistry config) {
        try {
            Jackson2Config cfg = (Jackson2Config)config.get(Jackson2Config.class);
            ObjectWriter writer = cfg.getMapper().writerFor(cfg.getMapper().constructType(type));
            Class<?> view = cfg.getSerializationView();
            if (view != null) {
                writer = writer.withView(view);
            }
            return writer.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UnableToProduceResultException((Throwable)e);
        }
    }

    public Object fromJson(Type type, String json, ConfigRegistry config) {
        try {
            Jackson2Config cfg = (Jackson2Config)config.get(Jackson2Config.class);
            ObjectReader reader = cfg.getMapper().readerFor(cfg.getMapper().constructType(type));
            Class<?> view = cfg.getDeserializationView();
            if (view != null) {
                reader = reader.withView(view);
            }
            return reader.readValue(json);
        }
        catch (IOException e) {
            throw new UnableToProduceResultException((Throwable)e);
        }
    }
}

