/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.jpa.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.SQLException;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.jpa.BindJpa;
import org.jdbi.v3.jpa.EntityMemberAccessException;
import org.jdbi.v3.jpa.internal.JpaClass;
import org.jdbi.v3.jpa.internal.JpaMember;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

public class BindJpaFactory
implements SqlStatementCustomizerFactory {
    public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
        BindJpa bind = (BindJpa)annotation;
        Object prefix = bind.value().isEmpty() ? "" : bind.value() + ".";
        return (arg_0, arg_1) -> BindJpaFactory.lambda$createForParameter$0((String)prefix, arg_0, arg_1);
    }

    private static Object readMember(Object entity, JpaMember member) {
        try {
            return member.read(entity);
        }
        catch (IllegalAccessException e) {
            String message = String.format("Unable to access property value for column %s", member.getColumnName());
            throw new EntityMemberAccessException(message, e);
        }
        catch (InvocationTargetException e) {
            String message = String.format("Exception thrown in accessor method for column %s", member.getColumnName());
            throw new EntityMemberAccessException(message, e);
        }
    }

    private static /* synthetic */ void lambda$createForParameter$0(String prefix, SqlStatement stmt, Object arg) throws SQLException {
        JpaClass<?> jpaClass = JpaClass.get(arg.getClass());
        for (JpaMember member : jpaClass.members()) {
            stmt.bindByType(prefix + member.getColumnName(), BindJpaFactory.readMember(arg, member), member.getQualifiedType());
        }
    }
}

