/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.json;

import java.lang.reflect.Type;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.json.Json;
import org.jdbi.v3.json.JsonConfig;
import org.jdbi.v3.json.JsonMapper;
import org.jdbi.v3.json.JsonPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class JsonPluginTest {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new JsonPlugin());

    @BeforeEach
    public void before() {
        this.h2Extension.getJdbi().useHandle(h -> h.createUpdate("create table foo(bar varchar)").execute());
    }

    @Test
    public void factoryChainWorks() {
        Jdbi jdbi = this.h2Extension.getJdbi();
        final Foo instance = new Foo();
        final String json = "foo";
        ((JsonConfig)jdbi.getConfig(JsonConfig.class)).setJsonMapper(new JsonMapper(){

            public JsonMapper.TypedJsonMapper forType(Type type, ConfigRegistry config) {
                Assertions.assertThat((Object)type).isEqualTo(Foo.class);
                return new JsonMapper.TypedJsonMapper(){

                    public String toJson(Object value, ConfigRegistry config) {
                        Assertions.assertThat((Object)value).isEqualTo(instance);
                        return json;
                    }

                    public Object fromJson(String readJson, ConfigRegistry config) {
                        Assertions.assertThat((String)readJson).isEqualTo(json);
                        return instance;
                    }
                };
            }
        });
        Object result = this.h2Extension.getJdbi().withHandle(h -> {
            ((Update)h.createUpdate("insert into foo(bar) values(:foo)").bindByType("foo", instance, QualifiedType.of(Foo.class).with(new Class[]{Json.class}))).execute();
            Assertions.assertThat((String)((String)h.createQuery("select bar from foo").mapTo(String.class).one())).isEqualTo(json);
            return (Foo)h.createQuery("select bar from foo").mapTo(QualifiedType.of(Foo.class).with(new Class[]{Json.class})).one();
        });
        Assertions.assertThat((Object)result).isSameAs((Object)instance);
    }

    public static class Foo {
        public String toString() {
            return "I am Foot.";
        }
    }
}

