/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.kotlin;

import java.lang.reflect.Type;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.kotlin.ExtensionsKt;
import org.jdbi.v3.core.kotlin.KotlinMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jdbi/v3/core/kotlin/KotlinMapperFactory;", "Lorg/jdbi/v3/core/mapper/RowMapperFactory;", "<init>", "()V", "build", "Ljava/util/Optional;", "Lorg/jdbi/v3/core/mapper/RowMapper;", "type", "Ljava/lang/reflect/Type;", "config", "Lorg/jdbi/v3/core/config/ConfigRegistry;", "jdbi3-kotlin"})
public final class KotlinMapperFactory
implements RowMapperFactory {
    @NotNull
    public Optional<RowMapper<?>> build(@NotNull Type type, @NotNull ConfigRegistry config) {
        Optional<RowMapper<?>> optional;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Class erasedType = GenericTypes.getErasedType((Type)type);
        Intrinsics.checkNotNull((Object)erasedType);
        if (ExtensionsKt.isKotlinClass(erasedType) && !Enum.class.isAssignableFrom(erasedType)) {
            Optional<KotlinMapper> optional2 = Optional.of(new KotlinMapper(erasedType, null, 2, null));
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        } else {
            Optional<RowMapper<?>> optional3 = Optional.empty();
            Intrinsics.checkNotNull(optional3);
            optional = optional3;
        }
        return optional;
    }
}

