/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class TestStatementsTimeout {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()});
    private Handle h;

    @BeforeEach
    public void setUp() {
        this.h = this.pgExtension.openHandle();
    }

    @AfterEach
    public void tearDown() {
        this.h.close();
    }

    @Test
    public void testTimeout() {
        ((SqlStatements)this.h.getConfig(SqlStatements.class)).setQueryTimeout(Integer.valueOf(2));
        Assertions.assertThatCode(() -> ((ResultIterable)this.h.createQuery("select pg_sleep(1)").mapTo(String.class)).one()).doesNotThrowAnyException();
        try (Query query = this.h.createQuery("select pg_sleep(3)");){
            ResultIterable iterable = query.mapTo(String.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ResultIterable)iterable).one()).isInstanceOf(UnableToExecuteStatementException.class)).hasCauseInstanceOf(PSQLException.class).matches(ex -> PSQLState.QUERY_CANCELED.getState().equals(((PSQLException)ex.getCause()).getSQLState()));
        }
    }
}

