/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.EnumSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestEnumSets {
    private static final GenericType<EnumSet<Platform>> PLATFORM_SET = new GenericType<EnumSet<Platform>>(){};
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withInitializer((ds, handle) -> handle.useTransaction(h -> {
        h.execute("drop table if exists videos", new Object[0]);
        h.execute("create table videos (id int primary key, supported_platforms bit(5))", new Object[0]);
        PreparedBatch batch = h.prepareBatch("insert into videos(id, supported_platforms) values (:id,:supported_platforms::varbit)");
        ((PreparedBatch)((PreparedBatch)batch.bind("id", 0)).bindByType("supported_platforms", EnumSet.of(Platform.IOS, Platform.ANDROID, Platform.WEB), PLATFORM_SET)).add();
        ((PreparedBatch)((PreparedBatch)batch.bind("id", 1)).bindByType("supported_platforms", EnumSet.of(Platform.SMART_TV), PLATFORM_SET)).add();
        ((PreparedBatch)((PreparedBatch)batch.bind("id", 2)).bindByType("supported_platforms", EnumSet.of(Platform.ANDROID, Platform.STB), PLATFORM_SET)).add();
        ((PreparedBatch)((PreparedBatch)batch.bind("id", 3)).bindByType("supported_platforms", EnumSet.of(Platform.IOS, Platform.WEB), PLATFORM_SET)).add();
        ((PreparedBatch)((PreparedBatch)batch.bind("id", 4)).bindByType("supported_platforms", EnumSet.noneOf(Platform.class), PLATFORM_SET)).add();
        ((PreparedBatch)((PreparedBatch)batch.bind("id", 5)).bindByType("supported_platforms", null, PLATFORM_SET)).add();
        batch.execute();
    }));
    private VideoDao videoDao;

    @BeforeEach
    public void setupDbi() {
        this.videoDao = (VideoDao)this.pgExtension.attach(VideoDao.class);
    }

    @Test
    public void testInserts() {
        this.videoDao.insert(6, EnumSet.of(Platform.IOS, Platform.ANDROID));
        Assertions.assertThat(this.getSupportedPlatforms(6)).containsExactly((Object[])new Platform[]{Platform.ANDROID, Platform.IOS});
    }

    @Test
    public void testInsertsEmpty() {
        this.videoDao.insert(7, EnumSet.noneOf(Platform.class));
        Assertions.assertThat(this.getSupportedPlatforms(7)).isEmpty();
    }

    @Test
    public void testInsertsNull() {
        this.videoDao.insert(8, null);
        Assertions.assertThat(this.getSupportedPlatforms(8)).isNull();
    }

    @Test
    public void testReads() {
        EnumSet<Platform> supportedPlatforms = this.videoDao.getSupportedPlatforms(0);
        Assertions.assertThat(supportedPlatforms).containsOnly((Object[])new Platform[]{Platform.ANDROID, Platform.IOS, Platform.WEB});
    }

    @Test
    public void testReadsEmpty() {
        EnumSet<Platform> supportedPlatforms = this.videoDao.getSupportedPlatforms(4);
        Assertions.assertThat(supportedPlatforms).isEmpty();
    }

    @Test
    public void testReadsNull() {
        EnumSet<Platform> supportedPlatforms = this.videoDao.getSupportedPlatforms(5);
        Assertions.assertThat(supportedPlatforms).isNull();
    }

    @Test
    public void testBitwiseWorksForNoneElements() {
        List<Integer> notNullVideos = this.videoDao.getSupportedVideosOnPlatforms(EnumSet.noneOf(Platform.class));
        Assertions.assertThat(notNullVideos).containsExactly((Object[])new Integer[]{0, 1, 2, 3, 4});
    }

    @Test
    public void testBitwiseWorksForOneElement() {
        List<Integer> stbVideos = this.videoDao.getSupportedVideosOnPlatforms(EnumSet.of(Platform.STB));
        Assertions.assertThat(stbVideos).containsOnlyOnce((Object[])new Integer[]{2});
    }

    @Test
    public void testBitwiseWorksForSeveralElements() {
        List<Integer> webIosVideos = this.videoDao.getSupportedVideosOnPlatforms(EnumSet.of(Platform.WEB, Platform.IOS));
        Assertions.assertThat(webIosVideos).containsExactly((Object[])new Integer[]{0, 3});
    }

    @Test
    public void testBitwiseAdditionWorks() {
        this.videoDao.addPlatforms(1, EnumSet.of(Platform.IOS, Platform.ANDROID));
        EnumSet<Platform> supportedPlatforms = this.getSupportedPlatforms(1);
        Assertions.assertThat(supportedPlatforms).containsExactly((Object[])new Platform[]{Platform.ANDROID, Platform.IOS, Platform.SMART_TV});
    }

    @Test
    public void testBitwiseRemovingWorks() {
        this.videoDao.removePlatforms(0, EnumSet.of(Platform.IOS, Platform.ANDROID, Platform.SMART_TV));
        EnumSet<Platform> supportedPlatforms = this.getSupportedPlatforms(0);
        Assertions.assertThat(supportedPlatforms).containsOnlyOnce((Object[])new Platform[]{Platform.WEB});
    }

    @Test
    public void testAmountPlatforms() {
        int amount = this.videoDao.getAmountOfSupportedPlatforms(0);
        Assertions.assertThat((int)amount).isEqualTo(3);
    }

    @Test
    public void throwsOnNonBitChars() {
        Handle handle = this.pgExtension.getSharedHandle();
        handle.execute("drop table if exists videos", new Object[0]);
        handle.execute("create table videos (id int primary key, supported_platforms varchar)", new Object[0]);
        handle.execute("discard all", new Object[0]);
        handle.useTransaction(h -> {
            int id = 1;
            String notBit = "2";
            ((Update)((Update)h.createUpdate("insert into videos(id, supported_platforms) values (:id, :notBits)").bind("id", id)).bind("notBits", "0101" + notBit)).execute();
            Assertions.assertThatThrownBy(() -> ((VideoDao)h.attach(VideoDao.class)).getSupportedPlatforms(id)).hasMessageContaining("non-bit character " + notBit);
        });
    }

    private EnumSet<Platform> getSupportedPlatforms(int id) {
        return (EnumSet)((Query)this.pgExtension.getSharedHandle().createQuery("select supported_platforms from videos where id=:id").bind("id", id)).mapTo(PLATFORM_SET).one();
    }

    public static interface VideoDao {
        @SqlUpdate(value="insert into videos(id, supported_platforms) values (:id, :platforms::varbit)")
        public void insert(int var1, EnumSet<Platform> var2);

        @SqlQuery(value="select supported_platforms from videos where id=:id")
        @SingleValue
        public EnumSet<Platform> getSupportedPlatforms(int var1);

        @SqlQuery(value="select id from videos where (supported_platforms & :platforms::varbit) = :platforms::varbit order by id")
        public List<Integer> getSupportedVideosOnPlatforms(EnumSet<Platform> var1);

        @SqlUpdate(value="update videos set supported_platforms = (supported_platforms | :platforms::varbit) where id=:id")
        public void addPlatforms(int var1, EnumSet<Platform> var2);

        @SqlUpdate(value="update videos set supported_platforms = (supported_platforms & ~:platforms::varbit) where id=:id")
        public void removePlatforms(int var1, EnumSet<Platform> var2);

        @SqlQuery(value="select length(replace(supported_platforms::varchar, '0', '')) from videos where id=:id")
        public int getAmountOfSupportedPlatforms(int var1);
    }

    public static enum Platform {
        ANDROID,
        IOS,
        SMART_TV,
        STB,
        WEB;

    }
}

