/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import com.google.common.collect.ImmutableList;
import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.time.Period;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestPeriod {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withInitializer((ds, h) -> h.useTransaction(th -> {
        th.execute("drop table if exists intervals", new Object[0]);
        th.execute("create table intervals(id int not null, foo interval)", new Object[0]);
        th.execute("insert into intervals(id, foo) values(1, interval '2 years -3 months 40 days')", new Object[0]);
        th.execute("insert into intervals(id, foo) values(2, interval '7 days')", new Object[0]);
        th.execute("insert into intervals(id, foo) values(3, interval '10 years -3 months 100 seconds')", new Object[0]);
    }));
    private final Period testPeriod = Period.of(1776, 7, 4);
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.pgExtension.getSharedHandle();
    }

    @Test
    public void testReadsViaFluentAPI() {
        List periods = this.handle.createQuery("select foo from intervals where id = 1 or id = 2 order by id").mapTo(Period.class).list();
        Assertions.assertThat((List)periods).isEqualTo((Object)ImmutableList.of((Object)Period.of(1, 9, 40), (Object)Period.of(0, 0, 7)));
    }

    @Test
    public void testTrivialPeriod() {
        this.handle.execute("insert into intervals(id, foo) values(?, ?)", new Object[]{4, Period.of(0, 0, 0)});
        Period p = (Period)((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 4)).mapTo(Period.class).one();
        Assertions.assertThat((boolean)p.isZero()).isTrue();
    }

    @Test
    public void testHandlesNulls() {
        this.handle.execute("insert into intervals(id, foo) values(?, ?)", new Object[]{5, null});
        Period p = (Period)((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 5)).mapTo(Period.class).one();
        Assertions.assertThat((Period)p).isNull();
    }

    @Test
    public void testWritesViaFluentApi() {
        this.handle.execute("insert into intervals(id, foo) values(?, ?)", new Object[]{6, this.testPeriod});
        Period p = (Period)((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 6)).mapTo(Period.class).one();
        Assertions.assertThat((Period)p).isEqualTo((Object)this.testPeriod);
    }

    @Test
    public void testInvalidPeriod() {
        Assertions.assertThatThrownBy(() -> ((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 3)).mapTo(Period.class).one()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testNegativePeriod() {
        this.handle.execute("insert into intervals(id, foo) values(?, interval '-3 years -1 month 2 days')", new Object[]{7});
        Period p = (Period)((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 7)).mapTo(Period.class).one();
        Assertions.assertThat((Period)p).isEqualTo((Object)Period.of(-3, -1, 2));
    }
}

