/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestSqlArrays {
    private static final String U_SELECT = "SELECT u FROM uuids";
    private static final String U_INSERT = "INSERT INTO uuids VALUES(:uuids, NULL, NULL)";
    private static final String I_SELECT = "SELECT i FROM uuids";
    private static final String I_INSERT = "INSERT INTO uuids VALUES(NULL, :ints, NULL)";
    private static final String T_SELECT = "SELECT t FROM uuids";
    private static final String T_INSERT = "INSERT INTO uuids VALUES(NULL, NULL, :instants)";
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withInitializer((ds, h) -> h.useTransaction(th -> {
        th.execute("DROP TABLE IF EXISTS uuids", new Object[0]);
        th.execute("CREATE TABLE uuids (u UUID[], i INT[], t TIMESTAMPTZ[])", new Object[0]);
    }));
    private Handle handle;
    private ArrayObject ao;
    private final UUID[] testUuids = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};
    private final int[] testInts = new int[]{5, 4, -6, 1, 9, Integer.MAX_VALUE, Integer.MIN_VALUE};
    private final Instant[] testInstants = new Instant[]{Instant.EPOCH, Instant.now().truncatedTo(ChronoUnit.MILLIS), Instant.ofEpochSecond(Integer.MIN_VALUE), Instant.ofEpochSecond(Integer.MAX_VALUE), Instant.parse("1583-01-01T00:00:00Z"), Instant.parse("9999-12-31T23:59:59Z")};

    @BeforeEach
    public void setUp() {
        this.handle = (Handle)this.pgExtension.openHandle().registerArrayType(Instant.class, "timestamptz");
        this.ao = (ArrayObject)this.handle.attach(ArrayObject.class);
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void testUuidArray() {
        this.ao.insertUuidArray(this.testUuids);
        Assertions.assertThat((Object[])this.ao.fetchUuidArray()).containsExactly((Object[])this.testUuids);
    }

    @Test
    public void testUuidList() {
        this.ao.insertUuidList(Arrays.asList(this.testUuids));
        Assertions.assertThat(this.ao.fetchUuidList()).contains((Object[])this.testUuids);
    }

    @Test
    public void testUuidArrayList() {
        this.ao.insertUuidList(Arrays.asList(this.testUuids));
        Assertions.assertThat(this.ao.fetchUuidArrayList()).contains((Object[])this.testUuids);
    }

    @Test
    public void testUuidLinkedList() {
        this.ao.insertUuidList(Arrays.asList(this.testUuids));
        Assertions.assertThat(this.ao.fetchUuidLinkedList()).contains((Object[])this.testUuids);
    }

    @Test
    public void testUuidCopyOnWriteArrayList() {
        this.ao.insertUuidList(Arrays.asList(this.testUuids));
        Assertions.assertThat(this.ao.fetchUuidCopyOnWriteArrayList()).contains((Object[])this.testUuids);
    }

    @Test
    public void testIntArray() {
        this.ao.insertIntArray(this.testInts);
        int[] actuals = this.ao.fetchIntArray();
        Assertions.assertThat((int[])actuals).containsExactly(this.testInts);
    }

    @Test
    public void testEmptyIntArray() {
        this.ao.insertIntArray(new int[0]);
        Assertions.assertThat((int[])this.ao.fetchIntArray()).isEmpty();
    }

    @Test
    public void testBoxedIntArray() {
        Object[] source = (Integer[])IntStream.of(this.testInts).mapToObj(Integer::valueOf).toArray(Integer[]::new);
        this.ao.insertBoxedIntArray((Integer[])source);
        Object[] actuals = this.ao.fetchBoxedIntArray();
        Assertions.assertThat((Object[])actuals).containsExactly(source);
    }

    @Test
    public void testObjectArray() {
        this.ao.insertIntArray(this.testInts);
        Object[] actuals = this.ao.fetchObjectArray();
        Object[] expecteds = IntStream.of(this.testInts).mapToObj(Integer::valueOf).toArray(Object[]::new);
        Assertions.assertThat((Object[])actuals).containsExactly(expecteds);
    }

    @Test
    public void testIntList() {
        List<Integer> testIntList = Arrays.stream(this.testInts).boxed().collect(Collectors.toList());
        this.ao.insertIntList(testIntList);
        Assertions.assertThat(this.ao.fetchIntList()).containsExactlyElementsOf(testIntList);
    }

    @Test
    public void testNullArray() {
        this.ao.insertUuidArray(null);
        Assertions.assertThat((Object[])this.ao.fetchUuidArray()).isNull();
    }

    @Test
    public void testNullList() {
        this.ao.insertUuidList(null);
        Assertions.assertThat(this.ao.fetchUuidLinkedList()).isNull();
    }

    @Test
    public void testFloatArray() {
        float[] expected = new float[]{1.0f, 2.0f, 3.0f};
        Assertions.assertThat((float[])((float[])((Query)this.handle.createQuery("select :array").bind("array", (Object)expected)).mapTo(float[].class).one())).isEqualTo((Object)expected);
    }

    @Test
    public void testDoubleArray() {
        double[] expected = new double[]{1.0, 2.0, 3.0};
        Assertions.assertThat((double[])((double[])((Query)this.handle.createQuery("select :array").bind("array", (Object)expected)).mapTo(double[].class).one())).isEqualTo((Object)expected);
    }

    @Test
    public void testReusedArrayWithString() throws Exception {
        this.handle.registerArrayType(String.class, "text");
        Assertions.assertThat((Boolean)((Boolean)((Query)this.handle.createQuery("select :array = :array").bindArray("array", String.class, Collections.singletonList("element"))).mapTo(Boolean.TYPE).one())).isTrue();
    }

    @Test
    public void testInstantArray() {
        this.ao.insertInstantArray(this.testInstants);
        Assertions.assertThat((Object[])this.ao.fetchInstantArray()).containsExactly((Object[])this.testInstants);
    }

    @Test
    public void testInstantList() {
        this.ao.insertInstantList(Arrays.asList(this.testInstants));
        Assertions.assertThat(this.ao.fetchInstantList()).contains((Object[])this.testInstants);
    }

    @Test
    public void testInstantArrayList() {
        this.ao.insertInstantList(Arrays.asList(this.testInstants));
        Assertions.assertThat(this.ao.fetchInstantArrayList()).contains((Object[])this.testInstants);
    }

    @Test
    public void testInstantLinkedList() {
        this.ao.insertInstantList(Arrays.asList(this.testInstants));
        Assertions.assertThat(this.ao.fetchInstantLinkedList()).contains((Object[])this.testInstants);
    }

    @Test
    public void testInstantCopyOnWriteArrayList() {
        this.ao.insertInstantList(Arrays.asList(this.testInstants));
        Assertions.assertThat(this.ao.fetchInstantCopyOnWriteArrayList()).contains((Object[])this.testInstants);
    }

    @Test
    public void testWhereInArray() {
        WhereInDao dao = (WhereInDao)this.handle.attach(WhereInDao.class);
        dao.createTable();
        Something a = new Something(1, "Alice");
        Something b = new Something(2, "Bob");
        Something c = new Something(3, "Candace");
        Something d = new Something(4, "David");
        Something e = new Something(5, "Emily");
        dao.insert(a, b, c, d, e);
        Assertions.assertThat(dao.getByIds(1)).containsExactly((Object[])new Something[]{a});
        Assertions.assertThat(dao.getByIds(2)).containsExactly((Object[])new Something[]{b});
        Assertions.assertThat(dao.getByIds(3)).containsExactly((Object[])new Something[]{c});
        Assertions.assertThat(dao.getByIds(4)).containsExactly((Object[])new Something[]{d});
        Assertions.assertThat(dao.getByIds(5)).containsExactly((Object[])new Something[]{e});
        Assertions.assertThat(dao.getByIds(1, 2, 5)).containsExactly((Object[])new Something[]{a, b, e});
    }

    public static interface ArrayObject {
        @SqlQuery(value="SELECT u FROM uuids")
        @SingleValue
        public UUID[] fetchUuidArray();

        @SqlUpdate(value="INSERT INTO uuids VALUES(:uuids, NULL, NULL)")
        public void insertUuidArray(UUID[] var1);

        @SqlQuery(value="SELECT u FROM uuids")
        @SingleValue
        public List<UUID> fetchUuidList();

        @SqlQuery(value="SELECT u FROM uuids")
        @SingleValue
        public ArrayList<UUID> fetchUuidArrayList();

        @SqlQuery(value="SELECT u FROM uuids")
        @SingleValue
        public LinkedList<UUID> fetchUuidLinkedList();

        @SqlQuery(value="SELECT u FROM uuids")
        @SingleValue
        public CopyOnWriteArrayList<UUID> fetchUuidCopyOnWriteArrayList();

        @SqlUpdate(value="INSERT INTO uuids VALUES(:uuids, NULL, NULL)")
        public void insertUuidList(List<UUID> var1);

        @SqlQuery(value="SELECT i FROM uuids")
        @SingleValue
        public int[] fetchIntArray();

        @SqlQuery(value="SELECT i FROM uuids")
        @SingleValue
        public Integer[] fetchBoxedIntArray();

        @SqlQuery(value="SELECT i FROM uuids")
        @SingleValue
        public Object[] fetchObjectArray();

        @SqlUpdate(value="INSERT INTO uuids VALUES(NULL, :ints, NULL)")
        public void insertIntArray(int[] var1);

        @SqlUpdate(value="INSERT INTO uuids VALUES(NULL, :ints, NULL)")
        public void insertBoxedIntArray(Integer[] var1);

        @SqlQuery(value="SELECT i FROM uuids")
        @SingleValue
        public List<Integer> fetchIntList();

        @SqlUpdate(value="INSERT INTO uuids VALUES(NULL, :ints, NULL)")
        public void insertIntList(List<Integer> var1);

        @SqlQuery(value="SELECT t FROM uuids")
        @SingleValue
        public Instant[] fetchInstantArray();

        @SqlUpdate(value="INSERT INTO uuids VALUES(NULL, NULL, :instants)")
        public void insertInstantArray(Instant[] var1);

        @SqlQuery(value="SELECT t FROM uuids")
        @SingleValue
        public List<Instant> fetchInstantList();

        @SqlQuery(value="SELECT t FROM uuids")
        @SingleValue
        public ArrayList<Instant> fetchInstantArrayList();

        @SqlQuery(value="SELECT t FROM uuids")
        @SingleValue
        public LinkedList<Instant> fetchInstantLinkedList();

        @SqlQuery(value="SELECT t FROM uuids")
        @SingleValue
        public CopyOnWriteArrayList<Instant> fetchInstantCopyOnWriteArrayList();

        @SqlUpdate(value="INSERT INTO uuids VALUES(NULL, NULL, :instants)")
        public void insertInstantList(List<Instant> var1);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface WhereInDao {
        @SqlUpdate(value="create table something(id int, name text)")
        public void createTable();

        @SqlBatch(value="insert into something(id, name) values (:id, :name)")
        public void insert(Something ... var1);

        @SqlQuery(value="select * from something where id = any(:ids) order by id")
        public List<Something> getByIds(int ... var1);
    }
}

