/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.BatchChunkSize;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestBatchGeneratedKeys {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugin((JdbiPlugin)new SqlObjectPlugin()).withPlugin((JdbiPlugin)new PostgresPlugin());
    private Handle handle;
    private UsesBatching b;

    @BeforeEach
    public void setUp() {
        this.handle = this.pgExtension.openHandle();
        this.handle.execute("create table something (id serial primary key, name varchar)", new Object[0]);
        this.b = (UsesBatching)this.handle.attach(UsesBatching.class);
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void testReturnKey() {
        long[] ids = this.b.insertNames("a", "b", "c", "d", "e");
        Assertions.assertThat((long[])ids).containsExactly(new long[]{1L, 2L, 3L, 4L, 5L});
    }

    @Test
    public void testBeanReturn() {
        Object[] people = this.b.insertNamesToBean(Arrays.asList("a", "b", "c", "d", "e"));
        Assertions.assertThat((Object[])people).hasSize(5);
        for (int i = 0; i < people.length; ++i) {
            Assertions.assertThat((int)people[i].getId()).isEqualTo(i + 1);
            Assertions.assertThat((String)people[i].getName()).isEqualTo(this.nameByIndex(i));
        }
    }

    @Test
    public void testVarargsList() {
        List<Something> people = this.b.insertVarargs("a", "b", "c", "d", "e");
        Assertions.assertThat(people).hasSize(5);
        for (int i = 0; i < people.size(); ++i) {
            Assertions.assertThat((int)people.get(i).getId()).isEqualTo(i + 1);
            Assertions.assertThat((String)people.get(i).getName()).isEqualTo(this.nameByIndex(i));
        }
    }

    private String nameByIndex(int i) {
        return String.valueOf((char)(97 + i));
    }

    @BatchChunkSize(value=2)
    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface UsesBatching {
        @SqlBatch(value="insert into something (name) values (:name)")
        @GetGeneratedKeys
        public long[] insertNames(String ... var1);

        @SqlBatch(value="insert into something (name) values (:name)")
        @GetGeneratedKeys
        public Something[] insertNamesToBean(@Bind(value="name") Iterable<String> var1);

        @SqlBatch(value="insert into something (name) values (:name)")
        @GetGeneratedKeys
        public List<Something> insertVarargs(String ... var1);
    }
}

