/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableSet;
import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.Collections;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestJsonOperator {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withInitializer((ds, h) -> h.execute("create table something (id serial primary key, value jsonb)", new Object[0]));
    private KeyValueStore kvs;

    @BeforeEach
    public void setUp() {
        this.kvs = (KeyValueStore)this.pgExtension.attach(KeyValueStore.class);
    }

    @Test
    public void testHasProperty() {
        this.kvs.insert(1, "{\"a\":1, \"b\":2}");
        Assertions.assertThat(this.kvs.hasProperty("a")).isEqualTo((Object)ImmutableSet.of((Object)1));
        Assertions.assertThat(this.kvs.hasProperty("b")).isEqualTo((Object)ImmutableSet.of((Object)1));
        Assertions.assertThat(this.kvs.hasProperty("c")).isEqualTo(Collections.emptySet());
    }

    public static interface KeyValueStore {
        @SqlUpdate(value="insert into something (id, value) values (:id, cast(:value as jsonb))")
        public void insert(@Bind(value="id") int var1, @Bind(value="value") String var2);

        @SqlQuery(value="select id from something where value ?? :property")
        public Set<Integer> hasProperty(@Bind(value="property") String var1);
    }
}

