package org.jdbi.v3.postgres;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TestImmutablesHStore.Mappy}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new TestImmutablesHStore.Mappy.Builder()}.
 */
@Generated(from = "TestImmutablesHStore.Mappy", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMappy implements TestImmutablesHStore.Mappy {
  private final ImmutableMap<String, String> numbers;

  private ImmutableMappy(ImmutableMap<String, String> numbers) {
    this.numbers = numbers;
  }

  /**
   * @return The value of the {@code numbers} attribute
   */
  @Override
  public ImmutableMap<String, String> numbers() {
    return numbers;
  }

  /**
   * Copy the current immutable object by replacing the {@link TestImmutablesHStore.Mappy#numbers() numbers} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the numbers map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMappy withNumbers(Map<String, ? extends String> entries) {
    if (this.numbers == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableMappy(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMappy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMappy
        && equalTo(0, (ImmutableMappy) another);
  }

  private boolean equalTo(int synthetic, ImmutableMappy another) {
    return numbers.equals(another.numbers);
  }

  /**
   * Computes a hash code from attributes: {@code numbers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + numbers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Mappy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Mappy")
        .omitNullValues()
        .add("numbers", numbers)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link TestImmutablesHStore.Mappy} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Mappy instance
   */
  public static TestImmutablesHStore.Mappy copyOf(TestImmutablesHStore.Mappy instance) {
    if (instance instanceof ImmutableMappy) {
      return (ImmutableMappy) instance;
    }
    return new TestImmutablesHStore.Mappy.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link TestImmutablesHStore.Mappy Mappy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TestImmutablesHStore.Mappy", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private ImmutableMap.Builder<String, String> numbers = ImmutableMap.builder();

    /**
     * Creates a builder for {@link TestImmutablesHStore.Mappy Mappy} instances.
     * <pre>
     * new TestImmutablesHStore.Mappy.Builder()
     *    .putNumbers|putAllNumbers(String =&gt; String) // {@link TestImmutablesHStore.Mappy#numbers() numbers} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof TestImmutablesHStore.Mappy.Builder)) {
        throw new UnsupportedOperationException("Use: new TestImmutablesHStore.Mappy.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code Mappy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final TestImmutablesHStore.Mappy.Builder from(TestImmutablesHStore.Mappy instance) {
      Objects.requireNonNull(instance, "instance");
      putAllNumbers(instance.numbers());
      return (TestImmutablesHStore.Mappy.Builder) this;
    }

    /**
     * Put one entry to the {@link TestImmutablesHStore.Mappy#numbers() numbers} map.
     * @param key The key in the numbers map
     * @param value The associated value in the numbers map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final TestImmutablesHStore.Mappy.Builder putNumbers(String key, String value) {
      this.numbers.put(key, value);
      return (TestImmutablesHStore.Mappy.Builder) this;
    }

    /**
     * Put one entry to the {@link TestImmutablesHStore.Mappy#numbers() numbers} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final TestImmutablesHStore.Mappy.Builder putNumbers(Map.Entry<String, ? extends String> entry) {
      this.numbers.put(entry);
      return (TestImmutablesHStore.Mappy.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link TestImmutablesHStore.Mappy#numbers() numbers} map. Nulls are not permitted
     * @param entries The entries that will be added to the numbers map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final TestImmutablesHStore.Mappy.Builder numbers(Map<String, ? extends String> entries) {
      this.numbers = ImmutableMap.builder();
      return putAllNumbers(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link TestImmutablesHStore.Mappy#numbers() numbers} map. Nulls are not permitted
     * @param entries The entries that will be added to the numbers map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final TestImmutablesHStore.Mappy.Builder putAllNumbers(Map<String, ? extends String> entries) {
      this.numbers.putAll(entries);
      return (TestImmutablesHStore.Mappy.Builder) this;
    }

    /**
     * Builds a new {@link TestImmutablesHStore.Mappy Mappy}.
     * @return An immutable instance of Mappy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TestImmutablesHStore.Mappy build() {
      return new ImmutableMappy(numbers.build());
    }
  }
}
