/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestByteaArrays {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withInitializer((ds, h) -> h.useTransaction(th -> {
        th.execute("DROP TABLE IF EXISTS t", new Object[0]);
        th.execute("CREATE TABLE t (b BYTEA[])", new Object[0]);
    }));
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.pgExtension.getSharedHandle();
    }

    @Test
    public void testByteaArrayMultiRows() {
        byte[] bytes1 = new byte[]{1, 2, 3};
        byte[] bytes2 = new byte[]{4, 8, 15, 16, 23, 42};
        int response = ((Update)this.handle.createUpdate("INSERT INTO t (b) VALUES (:b)").bindArray("b", (Object[])new byte[][]{bytes1, bytes2})).execute();
        Assertions.assertThat((int)response).isOne();
        ByteaDao dao = (ByteaDao)this.handle.attach(ByteaDao.class);
        List<byte[]> result = dao.getAsMultipleRows();
        Assertions.assertThat(result).isNotNull();
        Assertions.assertThat(result).hasSize(2);
        Assertions.assertThat(result).containsExactly((Object[])new byte[][]{bytes1, bytes2});
    }

    @Test
    public void testByteaArraySingleRow() throws Exception {
        byte[] bytes1 = new byte[]{1, 2, 3};
        byte[] bytes2 = new byte[]{4, 8, 15, 16, 23, 42};
        byte[] bytes3 = new byte[]{10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        byte[] bytes4 = new byte[]{1, 1, 2, 3, 5, 8, 13, 21};
        int response = ((Update)this.handle.createUpdate("INSERT INTO t (b) VALUES (:b)").bindArray("b", (Object[])new byte[][]{bytes1, bytes2})).execute();
        Assertions.assertThat((int)response).isOne();
        response = ((Update)this.handle.createUpdate("INSERT INTO t (b) VALUES (:b)").bindArray("b", (Object[])new byte[][]{bytes3, bytes4})).execute();
        Assertions.assertThat((int)response).isOne();
        ByteaDao dao = (ByteaDao)this.handle.attach(ByteaDao.class);
        List<byte[][]> result = dao.getAsSingleRows();
        Assertions.assertThat(result).isNotNull();
        Assertions.assertThat(result).hasSize(2);
        byte[][] result0 = result.get(0);
        Assertions.assertThat((int)result0.length).isEqualTo(2);
        Assertions.assertThat((byte[])result0[0]).containsExactly(bytes1);
        Assertions.assertThat((byte[])result0[1]).containsExactly(bytes2);
        byte[][] result1 = result.get(1);
        Assertions.assertThat((int)result1.length).isEqualTo(2);
        Assertions.assertThat((byte[])result1[0]).containsExactly(bytes3);
        Assertions.assertThat((byte[])result1[1]).containsExactly(bytes4);
    }

    static interface ByteaDao {
        @SqlQuery(value="SELECT b FROM t")
        @SingleValue
        public List<byte[]> getAsMultipleRows();

        @SqlQuery(value="SELECT b FROM t")
        public List<byte[][]> getAsSingleRows();
    }
}

