/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import de.softwareforge.testing.postgres.junit5.RequirePostgresVersion;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.stringtemplate4.StringTemplateSqlLocator;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

@RequirePostgresVersion(atLeast="10")
public class TestJsonOperator {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new PostgresPlugin(), new StringTemplateLocatorPlugin(TestJsonOperator.class)});

    @TestFactory
    @RequirePostgresVersion(atLeast="10")
    public Stream<DynamicTest> testPostgres10JsonFunctions() {
        return this.findDynamicTests("10");
    }

    @TestFactory
    @RequirePostgresVersion(atLeast="12")
    public Stream<DynamicTest> testPostgres12JsonFunctions() {
        return this.findDynamicTests("12");
    }

    @TestFactory
    @RequirePostgresVersion(atLeast="13")
    public Stream<DynamicTest> testPostgres13JsonFunctions() {
        return this.findDynamicTests("13");
    }

    @Test
    public void testJsonQueryWithBoundInput() {
        Assertions.assertThat((Boolean)((Boolean)((Query)this.pgExtension.getSharedHandle().createQuery("SELECT '{\"a\":1, \"b\":2}'::jsonb ?? :key").bind("key", "a")).mapTo(Boolean.TYPE).one())).isTrue();
    }

    private Stream<DynamicTest> findDynamicTests(String version) {
        STGroup parent = StringTemplateSqlLocator.findStringTemplateGroup(TestJsonOperator.class);
        ImmutableMap children = Maps.uniqueIndex((Iterable)parent.getImportedGroups(), STGroup::getName);
        STGroup testGroup = (STGroup)children.get("postgres_" + version + ".sql");
        ((ObjectAssert)Assertions.assertThat((Object)testGroup).withFailMessage("Could not load test group for postgres %s", new Object[]{version})).isNotNull();
        testGroup.load();
        Set templateNames = testGroup.getTemplateNames();
        for (String name : templateNames) {
            if (name.endsWith("Result")) {
                Assertions.assertThat((Collection)templateNames).contains((Object[])new String[]{name.substring(0, name.length() - 6)});
                continue;
            }
            Assertions.assertThat((Collection)templateNames).contains((Object[])new String[]{name + "Result"});
        }
        return templateNames.stream().map(s -> s.substring(1)).filter(s -> !s.endsWith("Result")).map(s -> DynamicTest.dynamicTest((String)s, () -> Assertions.assertThat((String)((String)this.pgExtension.getSharedHandle().createQuery(s).mapTo(String.class).one())).isEqualTo(this.getResult(testGroup, (String)s))));
    }

    private String getResult(STGroup testGroup, String queryName) {
        ST template = testGroup.getInstanceOf(queryName + "Result");
        ((ObjectAssert)Assertions.assertThat((Object)template).withFailMessage("Result template for query %s was not found!", new Object[]{queryName})).isNotNull();
        return template.render();
    }

    public static class StringTemplateLocatorPlugin
    implements JdbiPlugin {
        private final STGroup stGroup;
        private final TemplateEngine templateEngine;

        public StringTemplateLocatorPlugin(Class<?> clazz) {
            this.stGroup = StringTemplateSqlLocator.findStringTemplateGroup(clazz);
            this.templateEngine = (templateName, ctx) -> {
                ST template = this.stGroup.getInstanceOf(templateName);
                if (template == null) {
                    return templateName;
                }
                ctx.getAttributes().forEach((arg_0, arg_1) -> ((ST)template).add(arg_0, arg_1));
                return template.render();
            };
        }

        public void customizeJdbi(Jdbi jdbi) {
            ((SqlStatements)jdbi.getConfig(SqlStatements.class)).setTemplateEngine(this.templateEngine);
        }
    }
}

