/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestLobStream {
    private static final int BIG_DATA = 0x4000000;
    private Lobject lob;
    private Handle h;
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().withDatabasePreparer(ds -> Jdbi.create((DataSource)ds).withHandle(h -> h.execute("CREATE TABLE lob (id int, lob oid)", new Object[0]))).build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()});

    @BeforeEach
    public void setUp() throws SQLException {
        this.h = this.pgExtension.getSharedHandle();
        this.lob = (Lobject)this.h.attach(Lobject.class);
    }

    @Test
    public void blobCrud() throws IOException {
        Supplier<InputStream> expectedData = () -> new IntsInputStream(0, 255);
        this.h.useTransaction(th -> {
            Assertions.assertThat((int)this.lob.countLob()).isZero();
            this.lob.insert(1, (InputStream)expectedData.get());
            Assertions.assertThat((int)this.lob.countLob()).isOne();
            this.assertSameBytes(this.lob.findBlob(1), (InputStream)expectedData.get());
            this.lob.deleteLob(1);
            Assertions.assertThat((int)this.lob.countLob()).isZero();
            Assertions.assertThat((InputStream)this.lob.findBlob(1)).isNull();
        });
    }

    @Test
    public void clobCrud() throws IOException {
        Supplier<Reader> expectedData = () -> new IntsReader('0', 'z');
        this.h.useTransaction(th -> {
            this.lob.insert(2, (Reader)expectedData.get());
            this.assertSameChars(this.lob.findClob(2), (Reader)expectedData.get());
            this.lob.deleteLob(2);
        });
    }

    private void assertSameBytes(InputStream a, InputStream b) throws IOException {
        int read;
        int pos = 0;
        while ((read = a.read()) != -1) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)b.read()).describedAs("byte at position %s", new Object[]{pos})).isEqualTo(read);
            ++pos;
        }
        Assertions.assertThat((int)b.read()).isEqualTo(-1);
    }

    private void assertSameChars(Reader a, Reader b) throws IOException {
        int achar;
        int pos = 0;
        while ((achar = a.read()) != -1) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)b.read()).describedAs("char at position %s", new Object[]{pos})).isEqualTo(achar);
            ++pos;
        }
        Assertions.assertThat((int)b.read()).isEqualTo(-1);
    }

    public static interface Lobject {
        @SqlUpdate(value="insert into lob (id, lob) values (:id, :blob)")
        public void insert(int var1, InputStream var2);

        @SqlUpdate(value="insert into lob (id, lob) values (:id, :clob)")
        public void insert(int var1, Reader var2);

        @SqlQuery(value="select lob from lob where id = :id")
        public InputStream findBlob(int var1);

        @SqlQuery(value="select lob from lob where id = :id")
        public Reader findClob(int var1);

        @SqlUpdate(value="delete from lob where id = :id returning lo_unlink(lob)")
        public void deleteLob(int var1);

        @SqlQuery(value="select count(oid) from pg_largeobject_metadata")
        public int countLob();
    }

    class IntsReader
    extends Reader {
        private final char lo;
        private final char hi;
        private int count;
        private char current;

        IntsReader(char lo, char hi) {
            this.lo = lo;
            this.hi = hi;
            this.current = (char)(lo - '\u0001');
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int read = 0;
            for (int i = off; i < off + len; ++i) {
                if (this.count++ >= 0x4000000) {
                    return read > 0 ? read : -1;
                }
                this.current = (char)(this.current + '\u0001');
                if (this.current > this.hi) {
                    this.current = this.lo;
                }
                cbuf[i] = this.current;
                ++read;
            }
            return read;
        }

        @Override
        public void close() throws IOException {
        }
    }

    class IntsInputStream
    extends InputStream {
        private final int lo;
        private final int hi;
        private int count;
        private int current;

        IntsInputStream(int lo, int hi) {
            this.lo = lo;
            this.hi = hi;
            this.current = lo - 1;
        }

        @Override
        public int read() throws IOException {
            if (this.count++ >= 0x4000000) {
                return -1;
            }
            if (++this.current > this.hi) {
                this.current = this.lo;
            }
            return this.current;
        }
    }
}

