/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestUuid {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withInitializer((ds, h) -> h.useTransaction(th -> {
        th.execute("DROP TABLE IF EXISTS foo", new Object[0]);
        th.execute("CREATE TABLE foo (bar UUID, ary UUID[])", new Object[0]);
    }));
    public Handle handle;

    @BeforeEach
    public void setupDbi() {
        this.handle = this.pgExtension.openHandle();
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void testUuid() {
        UUID u = UUID.randomUUID();
        ((Update)this.handle.createUpdate("INSERT INTO foo VALUES (:uuid)").bind("uuid", u)).execute();
        Assertions.assertThat((Comparable)((UUID)this.handle.createQuery("SELECT * FROM foo").mapTo(UUID.class).one())).isEqualTo((Object)u);
    }

    @Test
    public void testUuidObject() {
        UuidObject uo = (UuidObject)this.handle.attach(UuidObject.class);
        Assertions.assertThat(uo.getUuids()).isEmpty();
        UUID u = UUID.randomUUID();
        uo.insert(u);
        Assertions.assertThat(uo.getUuids()).containsOnly((Object[])new UUID[]{u});
        uo.insert(u);
        Assertions.assertThat(uo.getUuids()).containsOnly((Object[])new UUID[]{u});
        UUID u1 = UUID.randomUUID();
        uo.insert(u1);
        Assertions.assertThat(uo.getUuids()).containsOnly((Object[])new UUID[]{u, u1});
    }

    @Test
    public void testNull() {
        UuidObject uo = (UuidObject)this.handle.attach(UuidObject.class);
        uo.insert(null);
        Assertions.assertThat((Comparable)uo.getUuid()).isNull();
    }

    @Test
    public void testUuidArray() {
        UuidObject uo = (UuidObject)this.handle.attach(UuidObject.class);
        Object[] ary = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};
        uo.insertArray((UUID[])ary);
        Assertions.assertThat((Object[])uo.getArray()).containsExactly(ary);
    }

    public static interface UuidObject {
        @SqlUpdate(value="INSERT INTO foo (bar) VALUES(:uuid)")
        public void insert(UUID var1);

        @SqlQuery(value="SELECT bar FROM foo")
        public Set<UUID> getUuids();

        @SqlQuery(value="select bar from foo")
        public UUID getUuid();

        @SqlUpdate(value="insert into foo (ary) values (:uuids)")
        public void insertArray(UUID ... var1);

        @SqlQuery(value="select ary from foo")
        @SingleValue
        public UUID[] getArray();
    }
}

