/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import com.google.common.collect.ImmutableList;
import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.time.Duration;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestDuration {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withInitializer((ds, h) -> h.useTransaction(th -> {
        th.execute("drop table if exists intervals", new Object[0]);
        th.execute("create table intervals(id int not null, foo interval)", new Object[0]);
        th.execute("insert into intervals(id, foo) values(1, interval '1 day 15:00:00')", new Object[0]);
        th.execute("insert into intervals(id, foo) values(2, interval '40 days 22 minutes')", new Object[0]);
        th.execute("insert into intervals(id, foo) values(3, interval '10 years -3 months 100 seconds')", new Object[0]);
    }));
    private Handle handle;
    private final Duration testDuration = Duration.ofDays(39L).plusHours(23L).plusMinutes(59L).plusSeconds(1L);

    @BeforeEach
    public void setUp() {
        this.handle = this.pgExtension.openHandle();
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void testReadsViaFluentAPI() {
        List periods = this.handle.createQuery("select foo from intervals where id = 1 or id = 2 order by id").mapTo(Duration.class).list();
        Assertions.assertThat((List)periods).isEqualTo((Object)ImmutableList.of((Object)Duration.ofDays(1L).plusHours(15L), (Object)Duration.ofDays(40L).plusMinutes(22L)));
    }

    @Test
    public void testTrivialDuration() {
        this.handle.execute("insert into intervals(id, foo) values(?, ?)", new Object[]{4, Duration.ZERO});
        Duration d = (Duration)((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 4)).mapTo(Duration.class).one();
        Assertions.assertThat((boolean)d.isZero()).isTrue();
    }

    @Test
    public void testHandlesNulls() {
        this.handle.execute("insert into intervals(id, foo) values(?, ?)", new Object[]{5, null});
        Duration d = (Duration)((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 5)).mapTo(Duration.class).one();
        Assertions.assertThat((Duration)d).isNull();
    }

    @Test
    public void testWritesViaFluentApi() {
        this.handle.execute("insert into intervals(id, foo) values(?, ?)", new Object[]{6, this.testDuration});
        Duration d = (Duration)((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 6)).mapTo(Duration.class).one();
        Assertions.assertThat((Duration)d).isEqualTo((Object)this.testDuration);
    }

    @Test
    public void testInvalidDuration() {
        Assertions.assertThatThrownBy(() -> ((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 3)).mapTo(Duration.class).one()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testReadNegativeDuration() {
        this.handle.execute("insert into intervals(id, foo) values(?, interval '-2 days -3 hours')", new Object[]{7});
        Duration d = (Duration)((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 7)).mapTo(Duration.class).one();
        Assertions.assertThat((Duration)d).isEqualTo((Object)Duration.ofDays(-2L).plusHours(-3L));
    }

    @Test
    public void testWriteReadNegativeDuration() {
        this.handle.execute("insert into intervals(id, foo) values(?, ?)", new Object[]{8, Duration.ofDays(-3L).plusMinutes(2L)});
        Duration d = (Duration)((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 8)).mapTo(Duration.class).one();
        Assertions.assertThat((Duration)d).isEqualTo((Object)Duration.ofDays(-3L).plusMinutes(2L));
    }

    @Test
    public void testWriteDurationTooBig() {
        Assertions.assertThatThrownBy(() -> this.handle.execute("insert into intervals(id, foo) values(?, ?)", new Object[]{9, Duration.ofDays(0x80000000L)})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testWriteDurationTooSmall() {
        Assertions.assertThatThrownBy(() -> this.handle.execute("insert into intervals(id, foo) values(?, ?)", new Object[]{10, Duration.ofSeconds(Long.MIN_VALUE)})).isInstanceOf(ArithmeticException.class);
    }

    @Test
    public void testTinyDuration() {
        this.handle.execute("insert into intervals(id, foo) values(?, interval '13us')", new Object[]{11});
        Duration d = (Duration)((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 11)).mapTo(Duration.class).one();
        Assertions.assertThat((Duration)d).isEqualTo((Object)Duration.ofNanos(13000L));
    }

    @Test
    public void testDurationTooPrecise() {
        Assertions.assertThatThrownBy(() -> this.handle.execute("insert into intervals(id, foo) values(?, ?)", new Object[]{12, Duration.ofNanos(100L)})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testFloatingPointMath() {
        this.handle.execute("insert into intervals(id, foo) values(?, interval '.129428s')", new Object[]{13});
        Duration d = (Duration)((Query)this.handle.createQuery("select foo from intervals where id=?").bind(0, 13)).mapTo(Duration.class).one();
        Assertions.assertThat((Duration)d).isEqualTo((Object)Duration.ofNanos(129428000L));
    }
}

