/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindMap;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestHStore {
    private static final GenericType<Map<String, String>> STRING_MAP = new GenericType<Map<String, String>>(){};
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().withDatabasePreparer(ds -> Jdbi.create((DataSource)ds).withHandle(h -> h.execute("create extension hstore", new Object[0]))).build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withInitializer((ds, h) -> h.useTransaction(th -> {
        th.execute("drop table if exists campaigns", new Object[0]);
        th.execute("create table campaigns(id int not null, caps hstore)", new Object[0]);
        th.execute("insert into campaigns(id, caps) values (1, 'yearly=>10000, monthly=>5000, daily=>200'::hstore)", new Object[0]);
        th.execute("insert into campaigns(id, caps) values (2, 'yearly=>1000, monthly=>200, daily=>20'::hstore)", new Object[0]);
    }));
    private Handle handle;
    private final Map<String, String> caps = ImmutableMap.of((Object)"yearly", (Object)"6000", (Object)"monthly", (Object)"1500", (Object)"daily", (Object)"100");

    @BeforeEach
    public void setUp() {
        this.handle = this.pgExtension.openHandle();
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void testReadsViaFluentAPI() {
        List initialCaps = this.handle.createQuery("select caps from campaigns order by id").mapTo(STRING_MAP).list();
        Assertions.assertThat((List)initialCaps).isEqualTo((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"yearly", (Object)"10000", (Object)"monthly", (Object)"5000", (Object)"daily", (Object)"200"), (Object)ImmutableMap.of((Object)"yearly", (Object)"1000", (Object)"monthly", (Object)"200", (Object)"daily", (Object)"20")));
    }

    @Test
    public void testHandlesEmptyMap() {
        this.handle.execute("insert into campaigns(id, caps) values (?,?)", new Object[]{4, ImmutableMap.of()});
        Map newCaps = (Map)((Query)this.handle.createQuery("select caps from campaigns where id=?").bind(0, 4)).mapTo(STRING_MAP).one();
        Assertions.assertThat((Map)newCaps).isEmpty();
    }

    @Test
    public void testHandlesNulls() {
        this.handle.execute("insert into campaigns(id, caps) values (?,?)", new Object[]{4, null});
        Map newCaps = (Map)((Query)this.handle.createQuery("select caps from campaigns where id=?").bind(0, 4)).mapTo(STRING_MAP).one();
        Assertions.assertThat((Map)newCaps).isNull();
    }

    @Test
    public void testRaisesExceptionWhenReadsWithWrongType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.handle.createQuery("select caps from campaigns order by id").mapTo((GenericType)new GenericType<Map<String, Object>>(){}).list()).isInstanceOf(NoSuchMapperException.class)).hasMessageContaining("No mapper registered for type java.util.Map<java.lang.String, java.lang.Object>");
    }

    @Test
    public void testWritesViaFluentApi() {
        this.handle.execute("insert into campaigns(id, caps) values (?,?)", new Object[]{3, this.caps});
        Map newCaps = (Map)((Query)this.handle.createQuery("select caps from campaigns where id=?").bind(0, 3)).mapTo(STRING_MAP).one();
        Assertions.assertThat((Map)newCaps).isEqualTo(this.caps);
    }

    @Test
    public void testSqlObjectApi() {
        CampaignDao campaignDao = (CampaignDao)this.handle.attach(CampaignDao.class);
        campaignDao.insertCampaign(3L, this.caps);
        Assertions.assertThat(campaignDao.getCampaignsCaps(3L)).isEqualTo(this.caps);
    }

    @Test
    public void testWritesWithBindMap() {
        CampaignDao campaignDao = (CampaignDao)this.handle.attach(CampaignDao.class);
        campaignDao.insertCampaignFromMap((Map<String, Object>)ImmutableMap.of((Object)"id", (Object)3, (Object)"caps", this.caps));
        Assertions.assertThat(campaignDao.getCampaignsCaps(3L)).isEqualTo(this.caps);
    }

    public static interface CampaignDao {
        @SqlQuery(value="select caps from campaigns where id=:id")
        @SingleValue
        public Map<String, String> getCampaignsCaps(@Bind(value="id") long var1);

        @SqlUpdate(value="insert into campaigns(id, caps) values (:id, :caps)")
        public void insertCampaign(@Bind(value="id") long var1, Map<String, String> var3);

        @SqlUpdate(value="insert into campaigns(id, caps) values (:id, :caps)")
        public int insertCampaignFromMap(@BindMap Map<String, Object> var1);
    }
}

