/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.immutables.value.Value;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.immutables.JdbiImmutables;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.postgres.HStore;
import org.jdbi.v3.postgres.ImmutableMappy;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.BindPojo;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestImmutablesHStore {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().withDatabasePreparer(ds -> Jdbi.create((DataSource)ds).withHandle(h -> h.execute("create extension hstore", new Object[0]))).build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withConfig(JdbiImmutables.class, c -> c.registerImmutable(Mappy.class)).withInitializer((ds, h) -> h.execute("create table mappy (numbers hstore not null)", new Object[0]));
    MappyDao dao;

    @BeforeEach
    public void setup() {
        this.dao = (MappyDao)this.pgExtension.attach(MappyDao.class);
    }

    @Test
    public void testMap() {
        Mappy row1 = Mappy.builder().putNumbers("one", "1").putNumbers("two", "2").build();
        this.dao.insert(row1);
        Mappy row2 = Mappy.builder().putNumbers("three", "3").putNumbers("four", "4").putNumbers("five", "5").build();
        this.dao.insert(row2);
        Assertions.assertThat(this.dao.select()).containsExactlyInAnyOrder((Object[])new Mappy[]{row1, row2});
    }

    public static interface MappyDao {
        @SqlUpdate(value="insert into mappy (numbers) values (:numbers)")
        public int insert(@BindPojo Mappy var1);

        @SqlQuery(value="select numbers from mappy")
        public List<Mappy> select();
    }

    @Value.Immutable
    @Value.Style(overshadowImplementation=true)
    public static interface Mappy {
        @HStore
        public Map<String, String> numbers();

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends ImmutableMappy.Builder {
        }
    }
}

