/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.TemporalOffset;
import org.assertj.core.data.TemporalUnitOffset;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestJavaTime {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg);
    Handle h;

    @BeforeEach
    public void setUp() {
        this.h = this.pgExtension.openHandle();
        this.h.useTransaction(th -> {
            th.execute("drop table if exists stuff", new Object[0]);
            th.execute("create table stuff (ts timestamp, d date, z text)", new Object[0]);
        });
    }

    @AfterEach
    public void tearDown() {
        this.h.close();
    }

    private TemporalUnitOffset getAllowableOffset() {
        return Assertions.within((long)0L, (TemporalUnit)ChronoUnit.MICROS);
    }

    @Test
    public void localDate() {
        LocalDate d = LocalDate.now();
        this.h.execute("insert into stuff(d) values (?)", new Object[]{d});
        Assertions.assertThat((LocalDate)((LocalDate)this.h.createQuery("select d from stuff").mapTo(LocalDate.class).one())).isEqualTo((Object)d);
    }

    @Test
    public void localDateTime() {
        LocalDateTime d = LocalDateTime.now();
        this.h.execute("insert into stuff(ts) values (?)", new Object[]{d});
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.h.createQuery("select ts from stuff").mapTo(LocalDateTime.class).one())).isCloseTo(d, (TemporalOffset)this.getAllowableOffset());
    }

    @Test
    public void offsetDateTime() {
        OffsetDateTime dt = OffsetDateTime.now().withOffsetSameInstant(ZoneOffset.UTC);
        this.h.execute("insert into stuff(ts) values (?)", new Object[]{dt});
        Assertions.assertThat((OffsetDateTime)((OffsetDateTime)this.h.createQuery("select ts from stuff").mapTo(OffsetDateTime.class).one())).isCloseTo(dt, (TemporalOffset)this.getAllowableOffset());
    }

    @Test
    public void offsetDateTimeLosesOffset() {
        OffsetDateTime dt = OffsetDateTime.now().withOffsetSameInstant(ZoneOffset.ofHours(-7));
        this.h.execute("insert into stuff(ts) values (?)", new Object[]{dt});
        Assertions.assertThat((OffsetDateTime)((OffsetDateTime)this.h.createQuery("select ts from stuff").mapTo(OffsetDateTime.class).one())).isCloseTo(dt, (TemporalOffset)this.getAllowableOffset());
    }

    @Test
    public void localTime() {
        this.h.execute("create table schedule (start time, stop time)", new Object[0]);
        LocalTime start = LocalTime.of(8, 30, 0);
        LocalTime stop = LocalTime.of(10, 30, 0);
        this.h.execute("insert into schedule (start, stop) values (?,?)", new Object[]{start, stop});
        Assertions.assertThat((LocalTime)((LocalTime)this.h.createQuery("select start from schedule").mapTo(LocalTime.class).one())).isEqualTo((Object)start);
        Assertions.assertThat((LocalTime)((LocalTime)this.h.createQuery("select stop from schedule").mapTo(LocalTime.class).one())).isEqualTo((Object)stop);
    }

    @Test
    public void instant() {
        Instant leap = Instant.ofEpochMilli(-14159025000L);
        this.h.execute("insert into stuff values(?)", new Object[]{leap});
        Assertions.assertThat((Instant)((Instant)this.h.createQuery("select ts from stuff").mapTo(Instant.class).one())).isEqualTo((Object)leap);
    }

    @Test
    public void zoneId() {
        ZoneId zone = ZoneId.systemDefault();
        this.h.execute("insert into stuff(z) values (?)", new Object[]{zone});
        Assertions.assertThat((Object)((ZoneId)this.h.createQuery("select z from stuff").mapTo(ZoneId.class).one())).isEqualTo((Object)zone);
    }
}

