/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.postgres.MacAddr;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestMacAddr {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withInitializer((ds, h) -> h.execute("create table macaddrs (id int, address macaddr)", new Object[0]));

    @Test
    public void macAddr() {
        MacAddrDao dao = (MacAddrDao)this.pgExtension.attach(MacAddrDao.class);
        dao.insert(1, "deadbeef1234");
        Assertions.assertThat((String)dao.select(1)).isEqualTo("de:ad:be:ef:12:34");
        dao.insert(2, "1234567890ab");
        Assertions.assertThat((String)dao.select(2)).isEqualTo("12:34:56:78:90:ab");
    }

    public static interface MacAddrDao {
        @SqlUpdate(value="insert into macaddrs (id, address) values (:id, :address)")
        public void insert(int var1, @MacAddr String var2);

        @SqlQuery(value="select address from macaddrs where id = :id")
        @MacAddr
        public String select(int var1);
    }
}

