/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Call;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.postgres.FooBarPGType;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.postgres.PostgresTypes;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlCall;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGmoney;

public class TestPostgresTypes {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().withInstancePreparer(builder -> {
        String locale = SystemUtils.IS_OS_WINDOWS ? "English_United States" : "en_US.UTF-8";
        builder.addInitDbConfiguration("locale", locale);
    }).withDatabasePreparer(ds -> Jdbi.create((DataSource)ds).withHandle(h -> h.execute("create extension hstore", new Object[0]))).build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withConfig(PostgresTypes.class, pt -> pt.registerCustomType(FooBarPGType.class, "foo_bar_type")).withInitializer((ds, h) -> {
        h.useTransaction(th -> {
            th.execute("drop table if exists postgres_custom_types", new Object[0]);
            th.execute("create table postgres_custom_types(id integer not null, foo text, bar text, created_on timestamp)", new Object[0]);
            th.execute("drop function if exists get_foo_bars()", new Object[0]);
            th.execute("drop function if exists get_foo_bar(integer)", new Object[0]);
            th.execute("drop function if exists insert_foo_bar(foo_bar_type)", new Object[0]);
            th.execute("drop function if exists insert_foo_bars(foo_bar_type[])", new Object[0]);
            th.execute("drop type if exists foo_bar_type", new Object[0]);
            th.execute("CREATE TYPE foo_bar_type AS (id integer, foo text, bar text);", new Object[0]);
            th.execute("CREATE OR REPLACE FUNCTION get_foo_bars() RETURNS SETOF foo_bar_type AS \n$$ \nSELECT id, foo, bar FROM postgres_custom_types;\n$$ LANGUAGE sql;", new Object[0]);
            th.execute("CREATE OR REPLACE FUNCTION get_foo_bar(aId integer) RETURNS foo_bar_type AS \n$$ \nSELECT id, foo, bar FROM postgres_custom_types WHERE id = aId;\n$$ LANGUAGE sql;", new Object[0]);
            th.execute("CREATE OR REPLACE FUNCTION insert_foo_bar(aFooBar foo_bar_type) RETURNS void AS \n$$\nDECLARE\n\nBEGIN\nINSERT INTO postgres_custom_types(id, foo, bar, created_on) VALUES(aFooBar.id, aFooBar.foo, aFooBar.bar, current_timestamp);\nEND;\n$$ LANGUAGE plpgsql;", new Object[0]);
            th.execute("CREATE OR REPLACE FUNCTION insert_foo_bars(aFooBars foo_bar_type[]) RETURNS void AS \n$$\nDECLARE\nqFooBarType foo_bar_type;\nBEGIN\nFOREACH qFooBarType IN ARRAY aFooBars\nLOOP \nINSERT INTO postgres_custom_types(id, foo, bar, created_on) VALUES(qFooBarType.id, qFooBarType.foo, qFooBarType.bar, current_timestamp);END LOOP;\nEND;\n$$ LANGUAGE plpgsql;", new Object[0]);
        });
        h.execute("INSERT INTO postgres_custom_types(id, foo, bar, created_on) VALUES(1, 'foo1', 'bar1', current_timestamp)", new Object[0]);
        h.execute("INSERT INTO postgres_custom_types(id, foo, bar, created_on) VALUES(2, 'foo2', 'bar2', current_timestamp)", new Object[0]);
    });
    private Handle handle;

    @BeforeEach
    public void before() {
        this.handle = this.pgExtension.openHandle();
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void testReadViaFluentAPI() {
        FooBarPGType result = (FooBarPGType)((Object)this.handle.createQuery("SELECT get_foo_bar(1)").mapTo(FooBarPGType.class).one());
        Assertions.assertThat((Object)((Object)result)).isEqualTo((Object)new FooBarPGType(1, "foo1", "bar1"));
    }

    @Test
    public void testReadListViaFluentAPI() {
        List result = this.handle.createQuery("SELECT get_foo_bars()").mapTo(FooBarPGType.class).list();
        Assertions.assertThat((List)result).containsExactlyInAnyOrder((Object[])new FooBarPGType[]{new FooBarPGType(1, "foo1", "bar1"), new FooBarPGType(2, "foo2", "bar2")});
    }

    @Test
    public void testWriteViaFluentAPI() {
        FooBarPGType fooBar3 = new FooBarPGType(3, "foo3", "bar3");
        try (Call call = this.handle.createCall("SELECT insert_foo_bar(:fooBar)");){
            ((Call)call.bind("fooBar", (Object)fooBar3)).invoke();
            FooBarPGType result = (FooBarPGType)((Object)((Query)this.handle.createQuery("SELECT get_foo_bar(:id)").bind("id", fooBar3.getId())).mapTo(FooBarPGType.class).one());
            Assertions.assertThat((Object)((Object)fooBar3)).isEqualTo((Object)result);
        }
    }

    @Test
    public void testWriteArrayViaFluentAPI() {
        FooBarPGType fooBar5 = new FooBarPGType(5, "foo5", "bar5");
        FooBarPGType fooBar6 = new FooBarPGType(6, "foo6", "bar6");
        try (Call call = this.handle.createCall("SELECT insert_foo_bars(:fooBar)");){
            ((Call)call.bind("fooBar", (Object)new FooBarPGType[]{fooBar5, fooBar6})).invoke();
            FooBarPGType result5 = (FooBarPGType)((Object)((Query)this.handle.createQuery("SELECT get_foo_bar(:id)").bind("id", fooBar5.getId())).mapTo(FooBarPGType.class).one());
            FooBarPGType result6 = (FooBarPGType)((Object)((Query)this.handle.createQuery("SELECT get_foo_bar(:id)").bind("id", fooBar6.getId())).mapTo(FooBarPGType.class).one());
            Assertions.assertThat((Object)((Object)fooBar5)).isEqualTo((Object)result5);
            Assertions.assertThat((Object)((Object)fooBar6)).isEqualTo((Object)result6);
        }
    }

    @Test
    public void testReadViaObjectAPI() {
        PostgresCustomTypeDAO typeDAO = (PostgresCustomTypeDAO)this.handle.attach(PostgresCustomTypeDAO.class);
        FooBarPGType result = typeDAO.find(2);
        Assertions.assertThat((Object)((Object)result)).isEqualTo((Object)new FooBarPGType(2, "foo2", "bar2"));
    }

    @Test
    public void testReadListViaObjectAPI() {
        PostgresCustomTypeDAO typeDAO = (PostgresCustomTypeDAO)this.handle.attach(PostgresCustomTypeDAO.class);
        List<FooBarPGType> result = typeDAO.getAllFooBars();
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new FooBarPGType[]{new FooBarPGType(1, "foo1", "bar1"), new FooBarPGType(2, "foo2", "bar2")});
    }

    @Test
    public void testWriteViaObjectAPI() {
        PostgresCustomTypeDAO typeDAO = (PostgresCustomTypeDAO)this.handle.attach(PostgresCustomTypeDAO.class);
        FooBarPGType fooBar4 = new FooBarPGType(4, "foo4", "bar4");
        typeDAO.insertFooBar(fooBar4);
        FooBarPGType result = typeDAO.find(fooBar4.getId());
        Assertions.assertThat((Object)((Object)fooBar4)).isEqualTo((Object)result);
    }

    @Test
    public void testWriteArrayViaObjectAPI() {
        PostgresCustomTypeDAO typeDAO = (PostgresCustomTypeDAO)this.handle.attach(PostgresCustomTypeDAO.class);
        FooBarPGType fooBar7 = new FooBarPGType(7, "foo7", "bar7");
        FooBarPGType fooBar8 = new FooBarPGType(8, "foo8", "bar8");
        typeDAO.insertFooBarsArray(new FooBarPGType[]{fooBar7, fooBar8});
        FooBarPGType result7 = typeDAO.find(fooBar7.getId());
        FooBarPGType result8 = typeDAO.find(fooBar8.getId());
        Assertions.assertThat((Object)((Object)fooBar7)).isEqualTo((Object)result7);
        Assertions.assertThat((Object)((Object)fooBar8)).isEqualTo((Object)result8);
    }

    @Test
    public void testBindListAsArrayViaFluentAPI() {
        ArrayList<FooBarPGType> foos = new ArrayList<FooBarPGType>();
        foos.add(new FooBarPGType(9, "foo9", "bar9"));
        foos.add(new FooBarPGType(10, "foo10", "bar10"));
        try (Call call = this.handle.createCall("SELECT insert_foo_bars(:fooBar)");){
            ((Call)call.bindByType("fooBar", foos, (GenericType)new GenericType<List<FooBarPGType>>(){})).invoke();
            Assertions.assertThat((List)this.handle.createQuery("SELECT get_foo_bars()").mapTo(FooBarPGType.class).list()).containsExactlyInAnyOrder((Object[])new FooBarPGType[]{new FooBarPGType(1, "foo1", "bar1"), new FooBarPGType(2, "foo2", "bar2"), new FooBarPGType(9, "foo9", "bar9"), new FooBarPGType(10, "foo10", "bar10")});
        }
    }

    @Test
    public void testBindListAsArrayViaObjectAPI() {
        PostgresCustomTypeDAO typeDAO = (PostgresCustomTypeDAO)this.handle.attach(PostgresCustomTypeDAO.class);
        ArrayList<FooBarPGType> foos = new ArrayList<FooBarPGType>();
        foos.add(new FooBarPGType(11, "foo11", "bar11"));
        foos.add(new FooBarPGType(12, "foo12", "bar12"));
        typeDAO.insertFooBars(foos);
        Assertions.assertThat(typeDAO.getAllFooBars()).containsExactlyInAnyOrder((Object[])new FooBarPGType[]{new FooBarPGType(1, "foo1", "bar1"), new FooBarPGType(2, "foo2", "bar2"), new FooBarPGType(11, "foo11", "bar11"), new FooBarPGType(12, "foo12", "bar12")});
    }

    @Test
    public void testReadWriteBox() {
        Assertions.assertThat((Object)((PGbox)((Query)this.handle.select("select :box", new Object[0]).bind("box", (Object)new PGbox(1.0, 2.0, 3.0, 4.0))).mapTo(PGbox.class).one())).isEqualTo((Object)new PGbox(1.0, 2.0, 3.0, 4.0));
        Assertions.assertThat((Object[])((PGbox[])((Query)this.handle.select("select :boxes", new Object[0]).bind("boxes", (Object)new PGbox[]{new PGbox(1.0, 2.0, 3.0, 4.0), new PGbox(5.0, 6.0, 7.0, 8.0)})).mapTo(PGbox[].class).one())).containsExactly((Object[])new PGbox[]{new PGbox(1.0, 2.0, 3.0, 4.0), new PGbox(5.0, 6.0, 7.0, 8.0)});
    }

    @Test
    public void testReadWriteCircle() {
        Assertions.assertThat((Object)((PGcircle)((Query)this.handle.select("select :circle", new Object[0]).bind("circle", (Object)new PGcircle(1.0, 2.0, 3.0))).mapTo(PGcircle.class).one())).isEqualTo((Object)new PGcircle(1.0, 2.0, 3.0));
        Assertions.assertThat((Object[])((PGcircle[])((Query)this.handle.select("select :circles", new Object[0]).bind("circles", (Object)new PGcircle[]{new PGcircle(1.0, 2.0, 3.0), new PGcircle(4.0, 5.0, 6.0)})).mapTo(PGcircle[].class).one())).containsExactly((Object[])new PGcircle[]{new PGcircle(1.0, 2.0, 3.0), new PGcircle(4.0, 5.0, 6.0)});
    }

    @Test
    public void testReadWriteInterval() {
        Assertions.assertThat((Object)((PGInterval)((Query)this.handle.select("select :interval", new Object[0]).bind("interval", (Object)new PGInterval(1, 2, 3, 4, 5, 6.0))).mapTo(PGInterval.class).one())).isEqualTo((Object)new PGInterval(1, 2, 3, 4, 5, 6.0));
        Assertions.assertThat((Object[])((PGInterval[])((Query)this.handle.select("select :intervals", new Object[0]).bind("intervals", (Object)new PGInterval[]{new PGInterval(1, 2, 3, 4, 5, 6.0), new PGInterval(7, 8, 9, 10, 11, 12.0)})).mapTo(PGInterval[].class).one())).containsExactly((Object[])new PGInterval[]{new PGInterval(1, 2, 3, 4, 5, 6.0), new PGInterval(7, 8, 9, 10, 11, 12.0)});
    }

    @Test
    public void testReadWriteLine() {
        Assertions.assertThat((Object)((PGline)((Query)this.handle.select("select :line", new Object[0]).bind("line", (Object)new PGline(1.0, 2.0, 3.0, 4.0))).mapTo(PGline.class).one())).isEqualTo((Object)new PGline(1.0, 2.0, 3.0, 4.0));
        Assertions.assertThat((Object[])((PGline[])((Query)this.handle.select("select :lines", new Object[0]).bind("lines", (Object)new PGline[]{new PGline(1.0, 2.0, 3.0, 4.0), new PGline(5.0, 6.0, 7.0, 8.0)})).mapTo(PGline[].class).one())).containsExactly((Object[])new PGline[]{new PGline(1.0, 2.0, 3.0, 4.0), new PGline(5.0, 6.0, 7.0, 8.0)});
    }

    @Test
    public void testReadWriteLseg() {
        Assertions.assertThat((Object)((PGlseg)((Query)this.handle.select("select :lseg", new Object[0]).bind("lseg", (Object)new PGlseg(1.0, 2.0, 3.0, 4.0))).mapTo(PGlseg.class).one())).isEqualTo((Object)new PGlseg(1.0, 2.0, 3.0, 4.0));
        Assertions.assertThat((Object[])((PGlseg[])((Query)this.handle.select("select :lsegs", new Object[0]).bind("lsegs", (Object)new PGlseg[]{new PGlseg(1.0, 2.0, 3.0, 4.0), new PGlseg(5.0, 6.0, 7.0, 8.0)})).mapTo(PGlseg[].class).one())).containsExactly((Object[])new PGlseg[]{new PGlseg(1.0, 2.0, 3.0, 4.0), new PGlseg(5.0, 6.0, 7.0, 8.0)});
    }

    @Test
    public void testReadWriteMoney() {
        Assertions.assertThat((Object)((PGmoney)((Query)this.handle.select("select :money", new Object[0]).bind("money", (Object)new PGmoney(1.0))).mapTo(PGmoney.class).one())).isEqualTo((Object)new PGmoney(1.0));
        Assertions.assertThat((Object[])((PGmoney[])((Query)this.handle.select("select :moneys", new Object[0]).bind("moneys", (Object)new PGmoney[]{new PGmoney(1.0), new PGmoney(2.0)})).mapTo(PGmoney[].class).one())).containsExactly((Object[])new PGmoney[]{new PGmoney(1.0), new PGmoney(2.0)});
    }

    @Test
    public void testReadWritePath() {
        Assertions.assertThat((Object)((PGpath)((Query)this.handle.select("select :path", new Object[0]).bind("path", (Object)new PGpath(new PGpoint[]{new PGpoint(1.0, 2.0), new PGpoint(3.0, 4.0), new PGpoint(5.0, 6.0)}, true))).mapTo(PGpath.class).one())).isEqualTo((Object)new PGpath(new PGpoint[]{new PGpoint(1.0, 2.0), new PGpoint(3.0, 4.0), new PGpoint(5.0, 6.0)}, true));
        Assertions.assertThat((Object[])((PGpath[])((Query)this.handle.select("select :paths", new Object[0]).bind("paths", (Object)new PGpath[]{new PGpath(new PGpoint[]{new PGpoint(1.0, 2.0), new PGpoint(3.0, 4.0), new PGpoint(5.0, 6.0)}, true), new PGpath(new PGpoint[]{new PGpoint(7.0, 8.0), new PGpoint(9.0, 10.0), new PGpoint(11.0, 12.0)}, false)})).mapTo(PGpath[].class).one())).containsExactly((Object[])new PGpath[]{new PGpath(new PGpoint[]{new PGpoint(1.0, 2.0), new PGpoint(3.0, 4.0), new PGpoint(5.0, 6.0)}, true), new PGpath(new PGpoint[]{new PGpoint(7.0, 8.0), new PGpoint(9.0, 10.0), new PGpoint(11.0, 12.0)}, false)});
    }

    @Test
    public void testReadWritePoint() {
        Assertions.assertThat((Object)((PGpoint)((Query)this.handle.select("select :point", new Object[0]).bind("point", (Object)new PGpoint(1.0, 2.0))).mapTo(PGpoint.class).one())).isEqualTo((Object)new PGpoint(1.0, 2.0));
        Assertions.assertThat((Object[])((PGpoint[])((Query)this.handle.select("select :points", new Object[0]).bind("points", (Object)new PGpoint[]{new PGpoint(1.0, 2.0), new PGpoint(3.0, 4.0), new PGpoint(5.0, 6.0)})).mapTo(PGpoint[].class).one())).containsExactly((Object[])new PGpoint[]{new PGpoint(1.0, 2.0), new PGpoint(3.0, 4.0), new PGpoint(5.0, 6.0)});
    }

    @Test
    public void testReadWritePolygon() {
        Assertions.assertThat((Object)((PGpolygon)((Query)this.handle.select("select :polygon", new Object[0]).bind("polygon", (Object)new PGpolygon(new PGpoint[]{new PGpoint(1.0, 2.0), new PGpoint(3.0, 4.0), new PGpoint(5.0, 6.0)}))).mapTo(PGpolygon.class).one())).isEqualTo((Object)new PGpolygon(new PGpoint[]{new PGpoint(1.0, 2.0), new PGpoint(3.0, 4.0), new PGpoint(5.0, 6.0)}));
        Assertions.assertThat((Object[])((PGpolygon[])((Query)this.handle.select("select :polygons", new Object[0]).bind("polygons", (Object)new PGpolygon[]{new PGpolygon(new PGpoint[]{new PGpoint(1.0, 2.0), new PGpoint(3.0, 4.0), new PGpoint(5.0, 6.0)}), new PGpolygon(new PGpoint[]{new PGpoint(7.0, 8.0), new PGpoint(9.0, 10.0), new PGpoint(11.0, 12.0)})})).mapTo(PGpolygon[].class).one())).containsExactly((Object[])new PGpolygon[]{new PGpolygon(new PGpoint[]{new PGpoint(1.0, 2.0), new PGpoint(3.0, 4.0), new PGpoint(5.0, 6.0)}), new PGpolygon(new PGpoint[]{new PGpoint(7.0, 8.0), new PGpoint(9.0, 10.0), new PGpoint(11.0, 12.0)})});
    }

    public static interface PostgresCustomTypeDAO {
        @SqlQuery(value="select get_foo_bars()")
        public List<FooBarPGType> getAllFooBars();

        @SqlQuery(value="select get_foo_bar(:id)")
        public FooBarPGType find(@Bind(value="id") int var1);

        @SqlCall(value="select insert_foo_bar(:fooBar)")
        public void insertFooBar(@Bind(value="fooBar") FooBarPGType var1);

        @SqlCall(value="select insert_foo_bars(:fooBars)")
        public void insertFooBarsArray(@Bind(value="fooBars") FooBarPGType[] var1);

        @SqlCall(value="select insert_foo_bars(:fooBars)")
        public void insertFooBars(@Bind(value="fooBars") List<FooBarPGType> var1);
    }
}

