/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestTypedEnum {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin()}).withInitializer((ds, h) -> h.useTransaction(th -> {
        th.execute("DROP TABLE IF EXISTS values", new Object[0]);
        th.execute("DROP TYPE IF EXISTS enum_t", new Object[0]);
        th.execute("CREATE TYPE enum_t AS ENUM ('FOO', 'BAR', 'BAZ')", new Object[0]);
        th.execute("CREATE TABLE values (value enum_t)", new Object[0]);
    }));
    public Handle handle;

    @BeforeEach
    public void setupDbi() {
        this.handle = this.pgExtension.openHandle();
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void testBind() {
        ((Update)this.handle.createUpdate("INSERT INTO values VALUES(:value)").bind("value", (Object)EnumT.BAR)).execute();
        Assertions.assertThat((String)((String)this.handle.createQuery("SELECT * FROM values").mapTo(String.class).one())).isEqualTo("BAR");
    }

    @Test
    public void testMap() {
        this.handle.createUpdate("INSERT INTO values VALUES('BAZ')").execute();
        Assertions.assertThat((Comparable)((Object)((EnumT)((Object)this.handle.createQuery("SELECT * FROM values").mapTo(EnumT.class).one())))).isEqualTo((Object)EnumT.BAZ);
    }

    public static enum EnumT {
        FOO,
        BAR,
        BAZ;

    }
}

