/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Define {
    public String value() default "";

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, Object arg) {
            Define define = (Define)annotation;
            String name = define.value();
            if (name.isEmpty()) {
                if (param.isNamePresent()) {
                    name = param.getName();
                } else {
                    throw new UnsupportedOperationException("A @Define parameter was not given a name, and parameter name data is not present in the class file, for: " + param.getDeclaringExecutable() + " :: " + param);
                }
            }
            String key = name;
            return q -> q.define(key, arg);
        }
    }
}

