/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jdbi.v3.core.Call;
import org.jdbi.v3.core.HandleSupplier;
import org.jdbi.v3.core.OutParameters;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.core.util.GenericTypes;
import org.jdbi.v3.sqlobject.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.SqlObjects;

class CallHandler
extends CustomizingStatementHandler {
    private final Class<?> sqlObjectType;
    private final boolean returnOutParams;

    CallHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        this.sqlObjectType = sqlObjectType;
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType);
        Class returnClass = GenericTypes.getErasedType((Type)returnType);
        if (Void.TYPE.equals(returnClass)) {
            this.returnOutParams = false;
        } else if (OutParameters.class.isAssignableFrom(returnClass)) {
            this.returnOutParams = true;
        } else {
            throw new IllegalArgumentException("@SqlCall methods may only return null or OutParameters at present");
        }
    }

    @Override
    public Object invoke(Object target, Object[] args, HandleSupplier handle) {
        String sql = ((SqlObjects)handle.getConfig(SqlObjects.class)).getSqlLocator().locate(this.sqlObjectType, this.getMethod());
        Call call = handle.getHandle().createCall(sql);
        this.applyCustomizers((SqlStatement<?>)call, args);
        OutParameters ou = call.invoke();
        if (this.returnOutParams) {
            return ou;
        }
        return null;
    }
}

