/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.StatementContext;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SingleColumnMapper;

class DefaultGeneratedKeyMapper
implements RowMapper<Object> {
    private final Type returnType;
    private final String columnName;

    DefaultGeneratedKeyMapper(Type returnType, String columnName) {
        this.returnType = returnType;
        this.columnName = columnName;
    }

    public Object map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.rowMapperFor(ctx).map(rs, ctx);
    }

    public RowMapper<Object> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.rowMapperFor(ctx).specialize(rs, ctx);
    }

    private RowMapper<Object> rowMapperFor(StatementContext ctx) {
        ColumnMapper columnMapper = ctx.findColumnMapperFor(this.returnType).orElse(null);
        if (columnMapper != null) {
            return "".equals(this.columnName) ? new SingleColumnMapper(columnMapper, 1) : new SingleColumnMapper(columnMapper, this.columnName);
        }
        return (RowMapper)ctx.findRowMapperFor(this.returnType).orElseThrow(() -> new IllegalStateException("No column or row mapper for " + this.returnType));
    }
}

