/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.jdbi.v3.core.GeneratedKeys;
import org.jdbi.v3.core.HandleSupplier;
import org.jdbi.v3.core.ResultIterable;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.core.Update;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.util.GenericTypes;
import org.jdbi.v3.sqlobject.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.ResultReturner;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.exceptions.UnableToCreateSqlObjectException;

class UpdateHandler
extends CustomizingStatementHandler {
    private final Class<?> sqlObjectType;
    private final Function<Update, Object> returner;

    UpdateHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        this.sqlObjectType = sqlObjectType;
        boolean isGetGeneratedKeys = method.isAnnotationPresent(GetGeneratedKeys.class);
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType);
        if (isGetGeneratedKeys) {
            ResultReturner magic = ResultReturner.forMethod(sqlObjectType, method);
            GetGeneratedKeys ggk = method.getAnnotation(GetGeneratedKeys.class);
            RowMapper<?> mapper = ResultReturner.rowMapperFor(ggk, returnType);
            this.returner = update -> {
                GeneratedKeys o = update.executeAndReturnGeneratedKeys(mapper, ggk.columnName());
                return magic.result((ResultIterable<?>)o);
            };
        } else if (this.isNumeric(method.getReturnType())) {
            this.returner = update -> update.execute();
        } else if (this.isBoolean(method.getReturnType())) {
            this.returner = update -> update.execute() > 0;
        } else {
            throw new UnableToCreateSqlObjectException(this.invalidReturnTypeMessage(method, returnType));
        }
    }

    @Override
    public Object invoke(Object target, Object[] args, HandleSupplier handle) {
        String sql = ((SqlObjects)handle.getConfig(SqlObjects.class)).getSqlLocator().locate(this.sqlObjectType, this.getMethod());
        Update update = handle.getHandle().createUpdate(sql);
        this.applyCustomizers((SqlStatement<?>)update, args);
        return this.returner.apply(update);
    }

    private boolean isNumeric(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Void.TYPE);
    }

    private boolean isBoolean(Class<?> type) {
        return type.equals(Boolean.TYPE) || type.equals(Boolean.class);
    }

    private String invalidReturnTypeMessage(Method method, Type returnType) {
        return method.getDeclaringClass().getSimpleName() + "." + method.getName() + " method is annotated with @SqlUpdate so should return void, boolean, or Number but is returning: " + returnType;
    }
}

