/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.core.util.ReflectionArrayIterator;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface BindList {
    public String value() default "";

    public EmptyHandling onEmpty() default EmptyHandling.THROW;

    public static enum EmptyHandling {
        VOID,
        NULL,
        THROW;

        static final String valueNotHandledMessage = "EmptyHandling type on BindList not handled. Please report this to the jdbi developers.";
    }

    public static final class Util {
        private Util() {
        }

        static Iterator<?> toIterator(Object obj) {
            if (obj == null) {
                throw new IllegalArgumentException("cannot make iterator of null");
            }
            if (obj instanceof Iterable) {
                return ((Iterable)obj).iterator();
            }
            if (obj.getClass().isArray()) {
                if (obj instanceof Object[]) {
                    return Arrays.asList((Object[])obj).iterator();
                }
                return ReflectionArrayIterator.of((Object)obj);
            }
            throw new IllegalArgumentException(Util.getTypeWarning(obj.getClass()));
        }

        static boolean isEmpty(Object obj) {
            if (obj == null) {
                throw new IllegalArgumentException("cannot determine emptiness of null");
            }
            if (obj instanceof Collection) {
                return ((Collection)obj).isEmpty();
            }
            if (obj instanceof Iterable) {
                return !((Iterable)obj).iterator().hasNext();
            }
            if (obj.getClass().isArray()) {
                return Array.getLength(obj) == 0;
            }
            throw new IllegalArgumentException(Util.getTypeWarning(obj.getClass()));
        }

        private static String getTypeWarning(Class<?> type) {
            return "argument must be one of the following: Iterable, or an array/varargs (primitive or complex type); was " + type.getName() + " instead";
        }
    }

    public static final class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Object arg) {
            BindList bindList = (BindList)annotation;
            String name = ParameterUtil.getParameterName(bindList, bindList.value(), param);
            if (arg == null || Util.isEmpty(arg)) {
                switch (bindList.onEmpty()) {
                    case VOID: {
                        return stmt -> {
                            SqlStatement cfr_ignored_0 = (SqlStatement)stmt.define(name, (Object)"");
                        };
                    }
                    case NULL: {
                        return stmt -> {
                            SqlStatement cfr_ignored_0 = (SqlStatement)stmt.define(name, (Object)"null");
                        };
                    }
                    case THROW: {
                        throw new IllegalArgumentException(arg == null ? "argument is null; null was explicitly forbidden on this instance of BindList" : "argument is empty; emptiness was explicitly forbidden on this instance of BindList");
                    }
                }
                throw new IllegalStateException("EmptyHandling type on BindList not handled. Please report this to the jdbi developers.");
            }
            ArrayList list = new ArrayList();
            Iterator<?> iter = Util.toIterator(arg);
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            return stmt -> stmt.bindList(name, list);
        }
    }
}

