/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.mixins;

import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.TransactionalCallback;
import org.jdbi.v3.sqlobject.TransactionalConsumer;

public interface Transactional<This extends Transactional<This>> {
    public void begin();

    public void commit();

    public void rollback();

    public void savepoint(String var1);

    public void rollbackToSavepoint(String var1);

    public void releaseSavepoint(String var1);

    public <R, X extends Exception> R inTransaction(TransactionalCallback<R, This, X> var1) throws X;

    public <R, X extends Exception> R inTransaction(TransactionIsolationLevel var1, TransactionalCallback<R, This, X> var2) throws X;

    default public <X extends Exception> void useTransaction(TransactionalConsumer<This, X> callback) throws X {
        this.inTransaction(transactional -> {
            callback.useTransaction(transactional);
            return null;
        });
    }

    default public <X extends Exception> void useTransaction(TransactionIsolationLevel isolation, TransactionalConsumer<This, X> callback) throws X {
        this.inTransaction(isolation, transactional -> {
            callback.useTransaction(transactional);
            return null;
        });
    }
}

