/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

@ConfiguringAnnotation(value=Impl.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterRowMapper {
    public Class<? extends RowMapper<?>>[] value();

    public static class Impl
    implements Configurer {
        @Override
        public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
            this.configureForType(registry, annotation, sqlObjectType);
        }

        @Override
        public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
            RegisterRowMapper registerRowMapper = (RegisterRowMapper)annotation;
            RowMappers mappers = (RowMappers)registry.get(RowMappers.class);
            try {
                Class<? extends RowMapper<?>>[] rowMapperTypes = registerRowMapper.value();
                for (int i = 0; i < rowMapperTypes.length; ++i) {
                    mappers.register(rowMapperTypes[i].newInstance());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create a specified row mapper", e);
            }
        }
    }
}

