/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.internal.JdbiStreams;
import org.jdbi.v3.sqlobject.DefaultMethodHandlerFactory;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.SqlMethodHandlerFactory;

public class Handlers
implements JdbiConfig<Handlers> {
    private final List<HandlerFactory> factories = new CopyOnWriteArrayList<HandlerFactory>();

    public Handlers() {
        this.register(new DefaultMethodHandlerFactory());
        this.register(new SqlMethodHandlerFactory());
    }

    private Handlers(Handlers that) {
        this.factories.addAll(that.factories);
    }

    public Handlers register(HandlerFactory factory) {
        this.factories.add(0, factory);
        return this;
    }

    public Optional<Handler> findFor(Class<?> sqlObjectType, Method method) {
        return this.factories.stream().flatMap(factory -> JdbiStreams.toStream(factory.buildHandler(sqlObjectType, method))).findFirst();
    }

    public Handlers createCopy() {
        return new Handlers(this);
    }
}

