/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.UseTemplateEngine;

public class UseTemplateEngineImpl
implements Configurer {
    @Override
    public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
        UseTemplateEngine anno = (UseTemplateEngine)annotation;
        try {
            TemplateEngine templateEngine = this.instantiate(anno.value(), sqlObjectType, method);
            ((SqlStatements)registry.get(SqlStatements.class)).setTemplateEngine(templateEngine);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
        UseTemplateEngine anno = (UseTemplateEngine)annotation;
        try {
            TemplateEngine templateEngine = this.instantiate(anno.value(), sqlObjectType, null);
            ((SqlStatements)registry.get(SqlStatements.class)).setTemplateEngine(templateEngine);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private TemplateEngine instantiate(Class<? extends TemplateEngine> value, Class<?> sqlObjectType, Method m) throws Exception {
        try {
            Constructor<? extends TemplateEngine> noArg = value.getConstructor(new Class[0]);
            return noArg.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<? extends TemplateEngine> classArg = value.getConstructor(Class.class);
                return classArg.newInstance(sqlObjectType);
            }
            catch (NoSuchMethodException e1) {
                if (m != null) {
                    Constructor<? extends TemplateEngine> constructor = value.getConstructor(Class.class, Method.class);
                    return constructor.newInstance(sqlObjectType, m);
                }
                throw new IllegalStateException("Unable to instantiate, no viable constructor " + value.getName());
            }
        }
    }
}

