/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.mapper.reflect.ConstructorMapper;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class AttachedHandleLeakTest {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withInitializer(TestingInitializers.usersWithData()).withConfig(RowMappers.class, r -> r.register(User.class, ConstructorMapper.of(User.class)));
    private UserDao dao;

    @BeforeEach
    public void setUp() {
        this.dao = (UserDao)this.h2Extension.getSharedHandle().attach(UserDao.class);
    }

    @Test
    public void testLeakDoNothing() {
        for (int i = 0; i < 1000; ++i) {
            ResultIterator<User> it = this.dao.getIterableUsers();
            Assertions.assertThat((Object)((User)it.next())).extracting("id").isEqualTo((Object)1);
        }
    }

    @Test
    public void testLeakCallClean() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            ResultIterator<User> it = this.dao.getIterableUsers();
            Assertions.assertThat((Object)((User)it.next())).extracting("id").isEqualTo((Object)1);
            this.dao.getHandle().clean();
        }
    }

    @Test
    public void testLeakTwr() {
        for (int i = 0; i < 1000; ++i) {
            try (ResultIterator<User> it = this.dao.getIterableUsers();){
                Assertions.assertThat((Object)((User)it.next())).extracting("id").isEqualTo((Object)1);
                continue;
            }
        }
    }

    @Test
    public void testLeakStreamDoNothing() {
        for (int i = 0; i < 1000; ++i) {
            Stream<User> stream = this.dao.getStreamingUsers();
            Assertions.assertThat(stream.findFirst()).containsInstanceOf(User.class);
        }
    }

    @Test
    public void testLeakStreamCallClean() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            Stream<User> stream = this.dao.getStreamingUsers();
            Assertions.assertThat(stream.findFirst()).containsInstanceOf(User.class);
            this.dao.getHandle().clean();
        }
    }

    @Test
    public void testLeakStreamTwr() {
        for (int i = 0; i < 1000; ++i) {
            try (Stream<User> stream = this.dao.getStreamingUsers();){
                Assertions.assertThat(stream.findFirst()).containsInstanceOf(User.class);
                continue;
            }
        }
    }

    @Test
    public void testLeakConsumer() {
        for (int i = 0; i < 1000; ++i) {
            this.dao.getIterableUsers(it -> Assertions.assertThat((Object)((User)it.next())).extracting("id").isEqualTo((Object)1));
        }
    }

    @Test
    public void testLeakStreamConsumer() {
        for (int i = 0; i < 1000; ++i) {
            this.dao.getStreamableUsers(stream -> Assertions.assertThat(stream.findFirst()).containsInstanceOf(User.class));
        }
    }

    public static interface UserDao
    extends SqlObject {
        @SqlQuery(value="SELECT * from users order by id")
        public ResultIterator<User> getIterableUsers();

        @SqlQuery(value="SELECT * from users order by id")
        public Stream<User> getStreamingUsers();

        @SqlQuery(value="SELECT * from users order by id")
        public void getIterableUsers(Consumer<Iterator<User>> var1);

        @SqlQuery(value="SELECT * from users order by id")
        public void getStreamableUsers(Consumer<Stream<User>> var1);
    }

    public static class User {
        private final int id;
        private final String name;

        public User(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return this.id == user.id && Objects.equals(this.name, user.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }
    }
}

