/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.transaction.SerializableTransactionRunner;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.BatchChunkSize;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class TestBatching {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
    }

    @Test
    public void testInsertSingleIterable() {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Something> toInsert = Arrays.asList(new Something(1, "Tom"), new Something(2, "Tatu"));
        int[] counts = b.insertBeans(toInsert);
        Assertions.assertThat((int[])counts).containsExactly(new int[]{1, 1});
        Assertions.assertThat((int)b.size()).isEqualTo(2);
    }

    @Test
    public void testInsertSingleIteratorNoTx() {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Something> toInsert = Arrays.asList(new Something(1, "Tom"), new Something(2, "Tatu"));
        int[] counts = b.insertBeansNoTx(toInsert.iterator());
        Assertions.assertThat((int[])counts).containsExactly(new int[]{1, 1});
        Assertions.assertThat((int)b.size()).isEqualTo(2);
    }

    @Test
    public void testBindConstantNull() {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Integer> ids = Arrays.asList(1, 2, 3, 4, 5);
        b.withConstantValue(ids, null);
        Assertions.assertThat((int)b.size()).isEqualTo(5);
        List names = this.handle.createQuery("select distinct name from something").mapTo(String.class).list();
        Assertions.assertThat((List)names).containsExactly((Object[])new String[]{null});
    }

    @Test
    public void testBindConstantValue() {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Integer> ids = Arrays.asList(1, 2, 3, 4, 5);
        b.withConstantValue(ids, "Johan");
        Assertions.assertThat((int)b.size()).isEqualTo(5);
        List names = this.handle.createQuery("select distinct name from something").mapTo(String.class).list();
        Assertions.assertThat((List)names).containsExactly((Object[])new String[]{"Johan"});
    }

    @Test
    public void testZipping() {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Integer> ids = Arrays.asList(1, 2, 3, 4, 5);
        List<String> names = Arrays.asList("David", "Tim", "Mike");
        b.zipArgumentsTogether(ids, names);
        Assertions.assertThat((int)b.size()).isEqualTo(3);
        List insNames = this.handle.createQuery("select distinct name from something order by name").mapTo(String.class).list();
        Assertions.assertThat((List)insNames).containsExactly((Object[])new String[]{"David", "Mike", "Tim"});
    }

    @Test
    public void testChunkedBatching() {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Something> things = Arrays.asList(new Something(1, "Brian"), new Something(2, "Henri"), new Something(3, "Patrick"), new Something(4, "Robert"), new Something(5, "Maniax"));
        int[] counts = b.insertChunked(things);
        Assertions.assertThat((int[])counts).hasSize(5).containsOnly(new int[]{1});
    }

    @Test
    public void testChunkedBatchingOnParam() {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Something> things = Arrays.asList(new Something(1, "Brian"), new Something(2, "Henri"), new Something(3, "Patrick"), new Something(4, "Robert"), new Something(5, "Maniax"));
        int[] counts = b.insertChunked(3, things);
        Assertions.assertThat((int[])counts).hasSize(5).containsOnly(new int[]{1});
    }

    @Test
    @Timeout(value=5L)
    public void testNoIterable() {
        BadBatch b = (BadBatch)this.handle.attach(BadBatch.class);
        Assertions.assertThatThrownBy(() -> b.insertBeans(new Something(1, "x"))).isInstanceOf(UnableToCreateStatementException.class);
    }

    @Test
    @Timeout(value=5L)
    public void testNoParameterAtAll() {
        BadBatch b = (BadBatch)this.handle.attach(BadBatch.class);
        Assertions.assertThatThrownBy(b::insertBeans).isInstanceOf(UnableToCreateStatementException.class);
    }

    @Test
    @Timeout(value=5L)
    public void testForgotIterableInt() {
        this.handle.execute("CREATE TABLE test (id int)", new Object[0]);
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        Assertions.assertThatThrownBy(() -> b.invalidInsertInt(1)).isInstanceOf(UnableToCreateStatementException.class);
    }

    @Test
    @Timeout(value=5L)
    public void testForgotIterableString() {
        this.handle.execute("CREATE TABLE test (id varchar)", new Object[0]);
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        Assertions.assertThatThrownBy(() -> b.invalidInsertString("bob")).isInstanceOf(UnableToCreateStatementException.class);
    }

    @Test
    public void testEmptyBatch() {
        this.handle.execute("CREATE TABLE test (id varchar)", new Object[0]);
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        Assertions.assertThat((int[])b.insertBeans(Collections.emptySet())).isEmpty();
    }

    @Test
    public void testBooleanReturn() {
        BooleanBatchDao dao = (BooleanBatchDao)this.handle.attach(BooleanBatchDao.class);
        Assertions.assertThat((boolean[])dao.insert(new Something(1, "foo"), new Something(2, "bar"))).containsExactly(new boolean[]{true, true});
        Assertions.assertThat((boolean[])dao.update(new Something(1, "baz"), new Something(3, "buz"))).containsExactly(new boolean[]{true, false});
    }

    @Test
    public void testBatchingWithSerializableTransactionRunner() {
        Jdbi jdbi = this.h2Extension.getJdbi();
        jdbi.setTransactionHandler((TransactionHandler)new SerializableTransactionRunner());
        jdbi.useHandle(jdbiHandle -> {
            Handle spyHandle = (Handle)Mockito.spy((Object)jdbiHandle);
            BDDMockito.given((Object)spyHandle.commit()).willAnswer(invocation -> {
                throw new SQLException("Test exception", "40001");
            }).willCallRealMethod();
            UsesBatching b = (UsesBatching)spyHandle.attach(UsesBatching.class);
            List<Something> things = Arrays.asList(new Something(1, "Brian"), new Something(2, "Henri"), new Something(3, "Patrick"), new Something(4, "Robert"), new Something(5, "Maniax"));
            int[] counts = b.insertChunked(2, things);
            Assertions.assertThat((int[])counts).hasSize(5).containsOnly(new int[]{1});
        });
    }

    @BatchChunkSize(value=4)
    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface UsesBatching {
        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public int[] insertBeans(@BindBean Iterable<Something> var1);

        @SqlBatch(value="insert into something (id, name) values (:id, :name)", transactional=false)
        public int[] insertBeansNoTx(@BindBean Iterator<Something> var1);

        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public int[] withConstantValue(@Bind(value="id") Iterable<Integer> var1, @Bind(value="name") String var2);

        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public int[] zipArgumentsTogether(@Bind(value="id") Iterable<Integer> var1, @Bind(value="name") List<String> var2);

        @SqlBatch(value="insert into something (id, name) values (:it.id, :it.name)")
        @BatchChunkSize(value=2)
        public int[] insertChunked(@BindBean(value="it") Iterable<Something> var1);

        @SqlBatch(value="insert into something (id, name) values (:it.id, :it.name)")
        public int[] insertChunked(@BatchChunkSize int var1, @BindBean(value="it") Iterable<Something> var2);

        @SqlQuery(value="select count(*) from something")
        public int size();

        @SqlBatch(value="insert into test (id) values (:id)")
        public void invalidInsertInt(@Bind(value="id") int var1);

        @SqlBatch(value="insert into test (id) values (:id)")
        public void invalidInsertString(@Bind(value="id") String var1);
    }

    public static interface BadBatch {
        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public int[] insertBeans(@BindBean Something var1);

        @SqlBatch(value="insert into something (id, name) values (0, '')")
        public int[] insertBeans();
    }

    public static interface BooleanBatchDao {
        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public boolean[] insert(Something ... var1);

        @SqlBatch(value="update something set name = :name where id = :id")
        public boolean[] update(Something ... var1);
    }
}

