/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestConsumer {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    Spiffy dao;
    List<Something> expected;

    @BeforeEach
    public void setup() {
        Something one = new Something(3, "foo");
        Something two = new Something(4, "bar");
        Something thr = new Something(5, "baz");
        this.dao = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        this.dao.insert(one);
        this.dao.insert(thr);
        this.dao.insert(two);
        this.expected = Arrays.asList(thr, two, one);
    }

    @Test
    public void consumeEach() {
        ArrayList results = new ArrayList();
        this.dao.forEach(results::add);
        Assertions.assertThat(results).containsExactlyElementsOf(this.expected);
    }

    @Test
    public void consumeIterator() {
        ArrayList results = new ArrayList();
        this.dao.consumeIterator(iter -> iter.forEachRemaining(results::add));
        Assertions.assertThat(results).containsExactlyElementsOf(this.expected);
    }

    @Test
    public void consumeStream() {
        ArrayList results = new ArrayList();
        this.dao.consumeStream(stream -> stream.forEach(results::add));
        Assertions.assertThat(results).containsExactlyElementsOf(this.expected);
    }

    @Test
    public void consumeMultiStream() {
        Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().attach(MultiConsumerDao.class)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void consumeIterable() {
        ArrayList results = new ArrayList();
        ArrayList results2 = new ArrayList();
        this.dao.consumeIterable(it -> {
            it.forEach(results::add);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> it.forEach(results2::add)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("stream has already been operated upon or closed");
        });
        Assertions.assertThat(results).containsExactlyElementsOf(this.expected);
        Assertions.assertThat(results2).isEmpty();
    }

    @Test
    public void consumeIterableIterator() {
        ArrayList results = new ArrayList();
        ArrayList results2 = new ArrayList();
        this.dao.consumeIterable(it -> {
            it.iterator().forEachRemaining(results::add);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> it.iterator().forEachRemaining(results2::add)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("stream has already been operated upon or closed");
        });
        Assertions.assertThat(results).containsExactlyElementsOf(this.expected);
        Assertions.assertThat(results2).isEmpty();
    }

    @Test
    public void testIteratorPartialConsumeOk() {
        ArrayList results = new ArrayList();
        this.dao.consumeIterator(iter -> results.add((Something)iter.next()));
        Assertions.assertThat(results).containsExactly((Object[])new Something[]{this.expected.get(0)});
    }

    @Test
    public void testStreamPartialConsumeOk() {
        ArrayList results = new ArrayList();
        this.dao.consumeStream(stream -> results.add(stream.findFirst().orElse(null)));
        Assertions.assertThat(results).containsExactly((Object[])new Something[]{this.expected.get(0)});
    }

    @Test
    public void testSubclassIteratorFails() {
        Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().attach(ResultIteratorDao.class)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testSubclassStreamFails() {
        Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().attach(SpecialStreamDao.class)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testConcreteStreamFails() {
        Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().attach(SomethingStreamDao.class)).isInstanceOf(IllegalArgumentException.class);
    }

    public static interface Spiffy {
        @SqlQuery(value="select id, name from something order by id desc")
        @UseRowMapper(value=SomethingMapper.class)
        public void forEach(Consumer<Something> var1);

        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public void consumeIterator(Consumer<Iterator<Something>> var1);

        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public void consumeStream(Consumer<Stream<Something>> var1);

        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public void consumeIterable(Consumer<Iterable<Something>> var1);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);
    }

    public static interface SomethingStreamDao {
        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public void consumeStream(Consumer<SomethingStream> var1);
    }

    public static interface SpecialStreamDao {
        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public void consumeStream(Consumer<SpecialStream<Something>> var1);
    }

    public static interface ResultIteratorDao {
        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public void consumeIterator(Consumer<ResultIterator<Something>> var1);
    }

    public static interface MultiConsumerDao {
        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public void consumeMultiStream(Consumer<Stream<Something>> var1, Consumer<Iterator<Something>> var2);
    }

    public static interface SpecialStream<T>
    extends Stream<T> {
    }

    public static interface SomethingStream
    extends Stream<Something> {
    }
}

