/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestDefineParameter {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
    }

    @Test
    public void testDefineParameter() {
        this.handle.execute("create table stuff (id identity primary key, name varchar(50))", new Object[0]);
        this.handle.execute("create table junk (id identity primary key, name varchar(50))", new Object[0]);
        HoneyBadger badass = (HoneyBadger)this.handle.attach(HoneyBadger.class);
        Something ted = new Something(1, "Ted");
        Something fred = new Something(2, "Fred");
        badass.insert("stuff", ted);
        badass.insert("junk", fred);
        Assertions.assertThat((Object)badass.findById("stuff", 1L)).isEqualTo((Object)ted);
        Assertions.assertThat((Object)badass.findById("junk", 1L)).isNull();
        Assertions.assertThat((Object)badass.findById("stuff", 2L)).isNull();
        Assertions.assertThat((Object)badass.findById("junk", 2L)).isEqualTo((Object)fred);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface HoneyBadger {
        @SqlUpdate(value="insert into <table> (id, name) values (:id, :name)")
        public void insert(@Define(value="table") String var1, @BindBean Something var2);

        @SqlQuery(value="select id, name from <table> where id = :id")
        public Something findById(@Define String var1, @Bind(value="id") long var2);
    }
}

