/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestFoldToObjectGraph {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    private Map<String, Team> expected;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
        this.handle.execute("create table team (name varchar(100),  mascot varchar(100), primary key (name))", new Object[0]);
        this.handle.execute("create table person(name varchar(100),  role varchar(100),  team varchar(100), primary key (name), foreign key (team) references team(name))", new Object[0]);
        this.handle.prepareBatch("insert into team (name, mascot) values (?, ?)").add(new Object[]{"A-Team", "The Van"}).add(new Object[]{"Hogan's Heroes", "The Tunnel"}).execute();
        this.handle.prepareBatch("insert into person (name, role, team) values (?, ?, ?)").add(new Object[]{"Kinchloe", "comms", "Hogan's Heroes"}).add(new Object[]{"Carter", "bombs", "Hogan's Heroes"}).add(new Object[]{"Murdoch", "driver", "A-Team"}).add(new Object[]{"Peck", "face", "A-Team"}).execute();
        Team ateam = new Team("A-Team", "The Van");
        ateam.getPeople().add(new Person("Murdoch", "driver"));
        ateam.getPeople().add(new Person("Peck", "face"));
        Team hogans = new Team("Hogan's Heroes", "The Tunnel");
        hogans.getPeople().add(new Person("Kinchloe", "comms"));
        hogans.getPeople().add(new Person("Carter", "bombs"));
        this.expected = ImmutableMap.of((Object)"Hogan's Heroes", (Object)hogans, (Object)"A-Team", (Object)ateam);
    }

    @Test
    public void testSqlObjectApi() {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        Assertions.assertThat(dao.findAllTeams()).isEqualTo(this.expected);
    }

    public static class Team {
        private final String name;
        private final String mascot;
        private final Set<Person> people = new LinkedHashSet<Person>();

        public Team(String name, String mascot) {
            this.name = name;
            this.mascot = mascot;
        }

        public String getName() {
            return this.name;
        }

        public String getMascot() {
            return this.mascot;
        }

        public Set<Person> getPeople() {
            return this.people;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Team that = (Team)o;
            return Objects.equals(this.mascot, that.mascot) && Objects.equals(this.name, that.name) && Objects.equals(this.people, that.people);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.mascot, this.people);
        }
    }

    public static class Person {
        private final String name;
        private final String role;

        public Person(String name, String role) {
            this.name = name;
            this.role = role;
        }

        public String getName() {
            return this.name;
        }

        public String getRole() {
            return this.role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.name.equals(person.name) && this.role.equals(person.role);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.role.hashCode();
            return result;
        }
    }

    public static interface Dao {
        @SqlQuery(value="select t.name as teamName,  t.mascot as mascot,  p.name as personName,  p.role as role from team t inner join person p on (t.name = p.team)")
        @RegisterBeanMapper(value=TeamPersonJoinRow.class)
        public Iterator<TeamPersonJoinRow> findAllTeamsAndPeople();

        default public Map<String, Team> findAllTeams() {
            Iterator<TeamPersonJoinRow> i = this.findAllTeamsAndPeople();
            HashMap<String, Team> acc = new HashMap<String, Team>();
            while (i.hasNext()) {
                TeamPersonJoinRow row = i.next();
                if (!acc.containsKey(row.getTeamName())) {
                    acc.put(row.getTeamName(), new Team(row.getTeamName(), row.getMascot()));
                }
                ((Team)acc.get(row.getTeamName())).getPeople().add(new Person(row.getPersonName(), row.getRole()));
            }
            return acc;
        }
    }

    public static class TeamPersonJoinRow {
        private String teamName;
        private String mascot;
        private String personName;
        private String role;

        public String getTeamName() {
            return this.teamName;
        }

        public String getMascot() {
            return this.mascot;
        }

        public String getPersonName() {
            return this.personName;
        }

        public String getRole() {
            return this.role;
        }

        public void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        public void setMascot(String mascot) {
            this.mascot = mascot;
        }

        public void setPersonName(String personName) {
            this.personName = personName;
        }

        public void setRole(String role) {
            this.role = role;
        }
    }
}

