/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.guava.GuavaPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestGuavaCollectors {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withPlugin((JdbiPlugin)new GuavaPlugin());
    Handle h;

    @BeforeEach
    public void setUp() {
        this.h = this.h2Extension.getSharedHandle();
        this.h.execute("create table users (id int, name varchar)", new Object[0]);
        this.h.execute("insert into users (id, name) values (?, ?)", new Object[]{1, "Alice"});
        this.h.execute("insert into users (id, name) values (?, ?)", new Object[]{2, "Bob"});
    }

    @Test
    public void testImmutableList() {
        Assertions.assertThat(((UserDao)this.h.attach(UserDao.class)).list()).containsExactly((Object[])new User[]{new User(1, "Alice"), new User(2, "Bob")});
    }

    @Test
    public void testOptional() {
        Assertions.assertThat((Object)((User)((UserDao)this.h.attach(UserDao.class)).getById(1L).get())).isEqualTo((Object)new User(1, "Alice"));
    }

    @RegisterConstructorMapper(value=User.class)
    public static interface UserDao {
        @SqlQuery(value="select * from users order by name")
        public ImmutableList<User> list();

        @SqlQuery(value="select * from users where id = :id")
        public Optional<User> getById(long var1);
    }

    public static class User {
        private final int id;
        private final String name;

        public User(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return this.id == user.id && Objects.equals(this.name, user.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            return "User{id=" + this.id + ", name='" + this.name + '\'' + '}';
        }
    }
}

