/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;
import org.jdbi.v3.core.qualifier.Reversed;
import org.jdbi.v3.core.qualifier.ReversedStringArgumentFactory;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.BindTime;
import org.jdbi.v3.sqlobject.BindTimeConfig;
import org.jdbi.v3.sqlobject.MockClock;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.locator.UseClasspathSqlLocator;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestInheritedAnnotations {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private final MockClock mockClock = MockClock.now();

    @BeforeEach
    public void setUp() {
        ((BindTimeConfig)this.h2Extension.getJdbi().getConfig(BindTimeConfig.class)).setClock(this.mockClock);
        Handle handle = this.h2Extension.getSharedHandle();
        handle.execute("CREATE TABLE characters (id INT, name VARCHAR, created TIMESTAMP, modified TIMESTAMP)", new Object[0]);
    }

    @Test
    public void testCrud() {
        Instant inserted = this.mockClock.instant();
        CharacterDao dao = (CharacterDao)this.h2Extension.getJdbi().onDemand(CharacterDao.class);
        dao.insert(new Character(1, "Moiraine Sedai"));
        Assertions.assertThat(dao.findById(1)).contains((Object)new Character(1, "Moiraine Sedai", inserted, inserted));
        Instant modified = this.mockClock.advance(10L, ChronoUnit.SECONDS);
        Assertions.assertThat((Instant)inserted).isBefore(modified);
        dao.update(new Character(1, "Mistress Alys"));
        Assertions.assertThat(dao.findById(1)).contains((Object)new Character(1, "Mistress Alys", inserted, modified));
        dao.delete(1);
        Assertions.assertThat(dao.findById(1)).isEmpty();
    }

    @Test
    public void testNonDirect() {
        ChildDao dao = (ChildDao)this.h2Extension.getJdbi().onDemand(ChildDao.class);
        Assertions.assertThat((String)dao.reversed("what")).isEqualTo("tahw");
    }

    @RegisterConstructorMapper(value=Character.class)
    public static interface CharacterDao
    extends CrudDao<Character, Integer> {
    }

    public static class Character {
        public final int id;
        public final String name;
        private final Instant created;
        private final Instant modified;

        public Character(int id, String name) {
            this(id, name, null, null);
        }

        @JdbiConstructor
        public Character(int id, String name, Instant created, Instant modified) {
            this.id = id;
            this.name = name;
            this.created = created;
            this.modified = modified;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Instant getCreated() {
            return this.created;
        }

        public Instant getModified() {
            return this.modified;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Character character = (Character)o;
            return this.id == character.id && Objects.equals(this.name, character.name) && Objects.equals(this.created, character.created) && Objects.equals(this.modified, character.modified);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.created, this.modified);
        }

        public String toString() {
            return "Character{id=" + this.id + ", name='" + this.name + '\'' + ", created=" + this.created + ", modified=" + this.modified + '}';
        }
    }

    public static interface ChildDao
    extends ParentDao {
    }

    public static interface ParentDao
    extends GrandParentDao {
    }

    @RegisterArgumentFactory(value=ReversedStringArgumentFactory.class)
    @BindTime
    public static interface GrandParentDao {
        @SqlQuery(value="SELECT :name, :now")
        public String reversed(@Reversed String var1);
    }

    @UseClasspathSqlLocator
    @BindTime
    public static interface CrudDao<T, ID> {
        @SqlUpdate
        public void insert(@BindBean T var1);

        @SqlQuery
        public Optional<T> findById(ID var1);

        @SqlUpdate
        public void update(@BindBean T var1);

        @SqlUpdate
        public void delete(ID var1);
    }
}

